/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.n3.JenaURIException;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.NodeConst;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.core.TriplePath;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Exists;
import com.hp.hpl.jena.sparql.expr.E_NotExists;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.lang.TriplesDataCollector;
import com.hp.hpl.jena.sparql.path.P_Link;
import com.hp.hpl.jena.sparql.path.Path;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.syntax.TripleCollector;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import com.hp.hpl.jena.sparql.util.LabelToNodeMap;
import com.hp.hpl.jena.sparql.util.graph.GraphFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class ParserBase {
    protected final Node XSD_TRUE = NodeConst.nodeTrue;
    protected final Node XSD_FALSE = NodeConst.nodeFalse;
    protected final Node nRDFtype = NodeConst.nodeRDFType;
    protected final Node nRDFnil = NodeConst.nodeNil;
    protected final Node nRDFfirst = NodeConst.nodeFirst;
    protected final Node nRDFrest = NodeConst.nodeRest;
    protected final Node nRDFsubject = RDF.Nodes.subject;
    protected final Node nRDFpredicate = RDF.Nodes.predicate;
    protected final Node nRDFobject = RDF.Nodes.object;
    protected boolean inConstructTemplate = false;
    final LabelToNodeMap bNodeLabels = LabelToNodeMap.createBNodeMap();
    final LabelToNodeMap anonVarLabels;
    LabelToNodeMap activeLabelMap = this.anonVarLabels = LabelToNodeMap.createVarMap();
    Set<String> oldLabels = new HashSet<String>();
    protected Prologue prologue;
    static final String bNodeLabelStart = "_:";
    boolean skolomizedBNodes = ARQ.isTrue(ARQ.constantBNodeLabels);

    public void setPrologue(Prologue prologue) {
        this.prologue = prologue;
    }

    public Prologue getPrologue() {
        return this.prologue;
    }

    protected void setInConstructTemplate(boolean b) {
        this.inConstructTemplate = b;
        this.activeLabelMap = this.inConstructTemplate ? this.bNodeLabels : this.anonVarLabels;
    }

    protected Element compressGroupOfOneGroup(ElementGroup elg) {
        Element e1;
        if (elg.getElements().size() == 1 && (e1 = elg.getElements().get(0)) instanceof ElementGroup) {
            return e1;
        }
        return elg;
    }

    protected Node createLiteralInteger(String lexicalForm) {
        return Node.createLiteral((String)lexicalForm, null, (RDFDatatype)XSDDatatype.XSDinteger);
    }

    protected Node createLiteralDouble(String lexicalForm) {
        return Node.createLiteral((String)lexicalForm, null, (RDFDatatype)XSDDatatype.XSDdouble);
    }

    protected Node createLiteralDecimal(String lexicalForm) {
        return Node.createLiteral((String)lexicalForm, null, (RDFDatatype)XSDDatatype.XSDdecimal);
    }

    protected Node stripSign(Node node) {
        if (!node.isLiteral()) {
            return node;
        }
        String lex = node.getLiteralLexicalForm();
        String lang = node.getLiteralLanguage();
        RDFDatatype dt = node.getLiteralDatatype();
        if (!lex.startsWith("-") && !lex.startsWith("+")) {
            throw new ARQInternalErrorException("Literal does not start with a sign: " + lex);
        }
        lex = lex.substring(1);
        return Node.createLiteral((String)lex, (String)lang, (RDFDatatype)dt);
    }

    protected Node createLiteral(String lexicalForm, String langTag, String datatypeURI) {
        Node n = null;
        if (datatypeURI != null) {
            RDFDatatype dType = TypeMapper.getInstance().getSafeTypeByName(datatypeURI);
            n = Node.createLiteral((String)lexicalForm, null, (RDFDatatype)dType);
        } else {
            n = Node.createLiteral((String)lexicalForm, (String)langTag, null);
        }
        return n;
    }

    protected long integerValue(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        if (s.startsWith("0x")) {
            s = s.substring(2);
            return Long.parseLong(s, 16);
        }
        return Long.parseLong(s);
    }

    protected double doubleValue(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        double valDouble = Double.parseDouble(s);
        return valDouble;
    }

    protected static String stripQuotes(String s) {
        return s.substring(1, s.length() - 1);
    }

    protected static String stripQuotes3(String s) {
        return s.substring(3, s.length() - 3);
    }

    public static String stripChars(String s, int n) {
        return s.substring(n, s.length());
    }

    protected Var createVariable(String s, int line, int column) {
        s = s.substring(1);
        return Var.alloc(s);
    }

    protected String resolveQuotedIRI(String iriStr, int line, int column) {
        iriStr = ParserBase.stripQuotes(iriStr);
        return this.resolveIRI(iriStr, line, column);
    }

    protected String resolveIRI(String iriStr, int line, int column) {
        if (this.isBNodeIRI(iriStr)) {
            return iriStr;
        }
        if (this.getPrologue() != null && this.getPrologue().getResolver() != null) {
            try {
                iriStr = this.getPrologue().getResolver().resolve(iriStr);
            }
            catch (JenaURIException ex) {
                ParserBase.throwParseException(ex.getMessage(), line, column);
            }
        }
        return iriStr;
    }

    protected String resolvePName(String qname, int line, int column) {
        String s = this.getPrologue().expandPrefixedName(qname);
        if (s == null) {
            ParserBase.throwParseException("Unresolved prefixed name: " + qname, line, column);
        }
        return s;
    }

    protected Node createNode(String iri) {
        if (this.isBNodeIRI(iri)) {
            String s = iri.substring(bNodeLabelStart.length());
            Node n = Node.createAnon((AnonId)new AnonId(s));
            return n;
        }
        return Node.createURI((String)iri);
    }

    protected boolean isBNodeIRI(String iri) {
        return this.skolomizedBNodes && iri.startsWith(bNodeLabelStart);
    }

    protected void startBasicGraphPattern() {
        this.activeLabelMap.clear();
    }

    protected void endBasicGraphPattern() {
        this.oldLabels.addAll(this.activeLabelMap.getLabels());
    }

    protected void startTriplesBlock() {
    }

    protected void endTriplesBlock() {
    }

    protected void startGroup(ElementGroup elg) {
        this.endBasicGraphPattern();
        this.startBasicGraphPattern();
    }

    protected void endGroup(ElementGroup elg) {
        this.endBasicGraphPattern();
    }

    protected Node createListNode() {
        return this.createBNode();
    }

    protected Node createBNode() {
        return this.activeLabelMap.allocNode();
    }

    protected Node createBNode(String label, int line, int column) {
        if (this.oldLabels.contains(label)) {
            ParserBase.throwParseException("Blank node reused across basic graph patterns: " + label, line, column);
        }
        return this.activeLabelMap.asNode(label);
    }

    protected Expr createExprExists(Element element) {
        return new E_Exists(element);
    }

    protected Expr createExprNotExists(Element element) {
        return new E_NotExists(element);
    }

    protected String fixupPrefix(String prefix, int line, int column) {
        if (prefix.endsWith(":")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    protected void insert(TripleCollector acc, Node s, Node p, Node o) {
        acc.addTriple(new Triple(s, p, o));
    }

    protected void insert(TripleCollector acc, int index, Node s, Node p, Node o) {
        acc.addTriple(index, new Triple(s, p, o));
    }

    protected void insert(TripleCollector acc, Node s, Node p, Path path, Node o) {
        if (p == null) {
            acc.addTriplePath(new TriplePath(s, path, o));
        } else {
            acc.addTriple(new Triple(s, p, o));
        }
    }

    protected void insert(TripleCollector acc, int index, Node s, Node p, Path path, Node o) {
        if (p == null) {
            acc.addTriplePath(index, new TriplePath(s, path, o));
        } else {
            acc.addTriple(index, new Triple(s, p, o));
        }
    }

    static Path fixPredicate(Node p) {
        if (p.isURI()) {
            return new P_Link(p);
        }
        return null;
    }

    protected Expr asExpr(Node n) {
        return ExprUtils.nodeToExpr(n);
    }

    protected Expr asExprNoSign(Node n) {
        String lex = n.getLiteralLexicalForm();
        String lang = n.getLiteralLanguage();
        String dtURI = n.getLiteralDatatypeURI();
        n = this.createLiteral(lex, lang, dtURI);
        return ExprUtils.nodeToExpr(n);
    }

    protected Graph convertTemplateToTriples(Template template, int line, int col) {
        ArrayList<Triple> acc = new ArrayList<Triple>();
        TriplesDataCollector collector = new TriplesDataCollector(acc, line, col);
        template.visit(collector);
        Graph g = GraphFactory.createPlainGraph();
        g.getBulkUpdateHandler().add(acc);
        return g;
    }

    public static String unescapeStr(String s) {
        return ParserBase.unescape(s, '\\', false, 1, 1);
    }

    public static String unescapeStr(String s, int line, int column) {
        return ParserBase.unescape(s, '\\', false, line, column);
    }

    public static String unescape(String s, char escape, boolean pointCodeOnly, int line, int column) {
        int i = s.indexOf(escape);
        if (i == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.substring(0, i));
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\n': 
                case '\r': {
                    ++line;
                    column = 1;
                    break;
                }
                default: {
                    ++column;
                }
            }
            if (ch != escape) {
                sb.append(ch);
            } else {
                int x;
                if (i >= s.length() - 1) {
                    ParserBase.throwParseException("Illegal escape at end of string", line, column);
                }
                char ch2 = s.charAt(i + 1);
                ++column;
                ++i;
                if (ch2 == 'u') {
                    if (i + 4 >= s.length()) {
                        ParserBase.throwParseException("\\u escape too short", line, column);
                    }
                    x = ParserBase.hex(s, i + 1, 4, line, column);
                    sb.append((char)x);
                    i += 4;
                    column += 4;
                } else if (ch2 == 'U') {
                    if (i + 8 >= s.length()) {
                        ParserBase.throwParseException("\\U escape too short", line, column);
                    }
                    x = ParserBase.hex(s, i + 1, 8, line, column);
                    sb.append((char)x);
                    i += 8;
                    column += 8;
                } else if (pointCodeOnly) {
                    sb.append('\\');
                    sb.append(ch2);
                    ++i;
                } else {
                    char ch3 = '\u0000';
                    switch (ch2) {
                        case 'n': {
                            ch3 = '\n';
                            break;
                        }
                        case 't': {
                            ch3 = '\t';
                            break;
                        }
                        case 'r': {
                            ch3 = '\r';
                            break;
                        }
                        case 'b': {
                            ch3 = '\b';
                            break;
                        }
                        case 'f': {
                            ch3 = '\f';
                            break;
                        }
                        case '\'': {
                            ch3 = '\'';
                            break;
                        }
                        case '\"': {
                            ch3 = '\"';
                            break;
                        }
                        case '\\': {
                            ch3 = '\\';
                            break;
                        }
                        default: {
                            ParserBase.throwParseException("Unknown escape: \\" + ch2, line, column);
                        }
                    }
                    sb.append(ch3);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static int hex(String s, int i, int len, int line, int column) {
        int x = 0;
        for (int j = i; j < i + len; ++j) {
            char ch = s.charAt(j);
            ++column;
            int k = 0;
            switch (ch) {
                case '0': {
                    k = 0;
                    break;
                }
                case '1': {
                    k = 1;
                    break;
                }
                case '2': {
                    k = 2;
                    break;
                }
                case '3': {
                    k = 3;
                    break;
                }
                case '4': {
                    k = 4;
                    break;
                }
                case '5': {
                    k = 5;
                    break;
                }
                case '6': {
                    k = 6;
                    break;
                }
                case '7': {
                    k = 7;
                    break;
                }
                case '8': {
                    k = 8;
                    break;
                }
                case '9': {
                    k = 9;
                    break;
                }
                case 'A': 
                case 'a': {
                    k = 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    k = 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    k = 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    k = 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    k = 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    k = 15;
                    break;
                }
                default: {
                    ParserBase.throwParseException("Illegal hex escape: " + ch, line, column);
                }
            }
            x = (x << 4) + k;
        }
        return x;
    }

    public static void throwParseException(String msg, int line, int column) {
        throw new QueryParseException("Line " + line + ", column " + column + ": " + msg, line, column);
    }
}

