/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionEnv;

public abstract class ExprFunction2
extends ExprFunction {
    Expr expr1 = null;
    Expr expr2 = null;

    protected ExprFunction2(Expr expr1, Expr expr2, String fName) {
        this(expr1, expr2, fName, null);
    }

    protected ExprFunction2(Expr expr1, Expr expr2, String fName, String opSign) {
        super(fName, opSign);
        this.expr1 = expr1;
        this.expr2 = expr2;
    }

    public Expr getArg1() {
        return this.getArg(1);
    }

    public Expr getArg2() {
        return this.getArg(2);
    }

    public Expr getArg(int i) {
        if (i == 1) {
            return this.expr1;
        }
        if (i == 2) {
            return this.expr2;
        }
        return null;
    }

    public int numArgs() {
        return 2;
    }

    public int hashCode() {
        return this.getFunctionSymbol().hashCode() ^ this.getArg1().hashCode() ^ this.getArg2().hashCode();
    }

    public final NodeValue eval(Binding binding, FunctionEnv env) {
        NodeValue s = this.evalSpecial(binding, env);
        if (s != null) {
            return s;
        }
        NodeValue x = this.expr1.eval(binding, env);
        NodeValue y = this.expr2.eval(binding, env);
        return this.eval(x, y, env);
    }

    protected NodeValue evalSpecial(Binding binding, FunctionEnv env) {
        return null;
    }

    public NodeValue eval(NodeValue x, NodeValue y, FunctionEnv env) {
        return this.eval(x, y);
    }

    public abstract NodeValue eval(NodeValue var1, NodeValue var2);

    public final Expr copySubstitute(Binding binding, boolean foldConstants) {
        Expr e1 = this.expr1.copySubstitute(binding, foldConstants);
        Expr e2 = this.expr2.copySubstitute(binding, foldConstants);
        if (foldConstants) {
            try {
                if (e1.isConstant() && e2.isConstant()) {
                    return this.eval(e1.getConstant(), e2.getConstant());
                }
            }
            catch (ExprEvalException ex) {
                // empty catch block
            }
        }
        return this.copy(e1, e2);
    }

    public abstract Expr copy(Expr var1, Expr var2);
}

