/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.Closeable;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.engine.OpEval;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.PlanOp;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.mgt.QueryEngineInfo;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.NodeFactory;

public abstract class QueryEngineBase
implements OpEval,
Closeable {
    public static final QueryEngineInfo queryEngineInfo = new QueryEngineInfo();
    protected DatasetGraph dataset = null;
    protected Context context;
    private Binding startBinding;
    private Op queryOp = null;
    private Plan plan = null;

    protected QueryEngineBase(Query query2, DatasetGraph dataset, Binding input, Context context) {
        this(dataset, input, context);
        this.context.put(ARQConstants.sysCurrentQuery, query2);
        query2.setResultVars();
        this.setOp(this.createOp(query2));
    }

    protected QueryEngineBase(Op op, DatasetGraph dataset, Binding input, Context context) {
        this(dataset, input, context);
        this.setOp(op);
    }

    private QueryEngineBase(DatasetGraph dataset, Binding input, Context context) {
        this.dataset = dataset;
        this.context = QueryEngineBase.setupContext(context, dataset);
        if (input == null) {
            ALog.warn(this, "Null initial input");
            input = BindingRoot.create();
        }
        this.startBinding = input;
    }

    private static Context setupContext(Context context, DatasetGraph dataset) {
        if (context == null) {
            context = ARQ.getContext();
        }
        context = context.copy();
        if (dataset.getContext() != null) {
            context.putAll(dataset.getContext());
        }
        context.set(ARQConstants.sysCurrentTime, NodeFactory.nowAsDateTime());
        return context;
    }

    public Plan getPlan() {
        if (this.plan == null) {
            this.plan = this.createPlan();
        }
        return this.plan;
    }

    protected Plan createPlan() {
        Op op = this.modifyOp(this.queryOp);
        QueryIterator queryIterator = null;
        queryIterator = this.dataset != null ? this.evaluate(op, this.dataset, this.startBinding, this.context) : this.evaluateNoMgt(op, this.dataset, this.startBinding, this.context);
        return new PlanOp(this.getOp(), this, queryIterator);
    }

    protected Op modifyOp(Op op) {
        return op;
    }

    protected Op createOp(Query query2) {
        Op op = Algebra.compile(query2);
        return op;
    }

    public final QueryIterator evaluate(Op op, DatasetGraph dsg, Binding binding, Context context) {
        queryEngineInfo.incQueryCount();
        queryEngineInfo.setLastQueryExecAt();
        queryEngineInfo.setLastQueryString((Query)context.get(ARQConstants.sysCurrentQuery));
        queryEngineInfo.setLastOp(op);
        return this.eval(op, dsg, binding, context);
    }

    private QueryIterator evaluateNoMgt(Op op, DatasetGraph dsg, Binding binding, Context context) {
        return this.eval(op, dsg, binding, context);
    }

    protected abstract QueryIterator eval(Op var1, DatasetGraph var2, Binding var3, Context var4);

    public Op getOp() {
        return this.queryOp;
    }

    protected Binding getStartBinding() {
        return this.startBinding;
    }

    public void close() {
    }

    protected void setOp(Op op) {
        this.queryOp = op;
        this.context.put(ARQConstants.sysCurrentAlgebra, op);
    }
}

