/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphCollection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetGraphMap
extends DatasetGraphCollection {
    private Map<Node, Graph> graphs = new HashMap<Node, Graph>();
    private Graph defaultGraph;

    private DatasetGraphMap() {
    }

    public DatasetGraphMap(Graph defaultGraph) {
        this.defaultGraph = defaultGraph;
    }

    public DatasetGraphMap(DatasetGraph dsg) {
        this(dsg.getDefaultGraph());
        Iterator<Node> names = dsg.listGraphNodes();
        while (names.hasNext()) {
            Node gn = names.next();
            dsg.addGraph(gn, dsg.getGraph(gn));
        }
    }

    @Override
    public boolean containsGraph(Node graphNode) {
        return this.graphs.containsKey(graphNode);
    }

    @Override
    public Graph getDefaultGraph() {
        return this.defaultGraph;
    }

    @Override
    public Graph getGraph(Node graphNode) {
        return this.graphs.get(graphNode);
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
        this.graphs.put(graphName, graph);
    }

    @Override
    public void removeGraph(Node graphName) {
        this.graphs.remove(graphName);
    }

    @Override
    public void setDefaultGraph(Graph g) {
        this.defaultGraph = g;
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return this.graphs.keySet().iterator();
    }

    @Override
    public long size() {
        return this.graphs.size();
    }

    @Override
    public void close() {
        this.defaultGraph.close();
        for (Graph graph : this.graphs.values()) {
            graph.close();
        }
        super.close();
    }
}

