/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.DatasetGraphBaseFind;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.lib.iterator.Iter;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatasetGraphCollection
extends DatasetGraphBaseFind {
    @Override
    public void add(Quad quad) {
        Graph g = this.fetchGraph(quad.getGraph());
        g.add(quad.asTriple());
    }

    @Override
    public void delete(Quad quad) {
        Graph g = this.fetchGraph(quad.getGraph());
        g.delete(quad.asTriple());
    }

    @Override
    protected Iterator<Quad> findInDftGraph(Node s, Node p, Node o) {
        return DatasetGraphCollection.triples2quadsDftGraph((Iterator<Triple>)this.getDefaultGraph().find(s, p, o));
    }

    protected Iter<Quad> findInSpecificNamedGraph(Node g, Node s, Node p, Node o) {
        Graph graph = this.fetchGraph(g);
        if (g == null) {
            return Iter.nullIter();
        }
        return DatasetGraphCollection.triples2quads(g, (Iterator<Triple>)graph.find(s, p, o));
    }

    @Override
    protected Iterator<Quad> findInAnyNamedGraphs(Node s, Node p, Node o) {
        Iterator<Node> gnames = this.listGraphNodes();
        Iterator iter = null;
        while (gnames.hasNext()) {
            Node gn = gnames.next();
            Iterator qIter = this.findInSpecificNamedGraph(gn, s, p, o);
            if (qIter == null) continue;
            iter = Iter.append(iter, qIter);
        }
        return iter;
    }

    @Override
    public abstract Iterator<Node> listGraphNodes();

    protected Graph fetchGraph(Node gn) {
        if (Quad.isDefaultGraph(gn)) {
            return this.getDefaultGraph();
        }
        return this.getGraph(gn);
    }
}

