/* Generated By:JavaCC: Do not edit this line. SPARQLParser11.java */
/*
 * (c) Copyright 2004, 2005, 2006, 2007, 2008, 2009 Hewlett-Packard Development Company, LP
 * (c) Copyright 2010 Talis Systems Ltd
 * All rights reserved.
 */

package com.hp.hpl.jena.sparql.lang.sparql_11 ;

import com.hp.hpl.jena.graph.* ;
import com.hp.hpl.jena.query.* ;
import com.hp.hpl.jena.sparql.core.Var ;
import com.hp.hpl.jena.sparql.syntax.* ;
import com.hp.hpl.jena.sparql.expr.* ;
import com.hp.hpl.jena.sparql.path.* ;
import com.hp.hpl.jena.sparql.expr.aggregate.* ;
import com.hp.hpl.jena.sparql.modify.op.* ;

public class SPARQLParser11 extends SPARQLParser11Base implements SPARQLParser11Constants {
    private static long UNSET = P_Mod.UNSET ;
    private static long INF = P_Mod.INF ;
    boolean allowAggregatesInExpressions = false ;

// Common top for single entry point.
  final public void Top() throws ParseException {
    Prologue();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
    case DESCRIBE:
    case CONSTRUCT:
    case ASK:
      Query();
      break;
    case INSERT:
    case DELETE:
    case LOAD:
    case CLEAR:
    case CREATE:
    case DROP:
    case WITH:
      Update();
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(0);
  }

// Query only entry point
  final public void QueryUnit() throws ParseException {
    Prologue();
    Query();
    jj_consume_token(0);
  }

  final public void Query() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
      SelectQuery();
      break;
    case CONSTRUCT:
      ConstructQuery();
      break;
    case DESCRIBE:
      DescribeQuery();
      break;
    case ASK:
      AskQuery();
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void Prologue() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BASE:
      BaseDecl();
      break;
    default:
      jj_la1[2] = jj_gen;
      ;
    }
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PREFIX:
        ;
        break;
      default:
        jj_la1[3] = jj_gen;
        break label_1;
      }
      PrefixDecl();
    }
  }

  final public void BaseDecl() throws ParseException {
                    String iri ;
    jj_consume_token(BASE);
    iri = IRI_REF();
    getPrologue().setBaseURI(iri) ;
  }

  final public void PrefixDecl() throws ParseException {
                      Token t ; String iri ;
    jj_consume_token(PREFIX);
    t = jj_consume_token(PNAME_NS);
    iri = IRI_REF();
        String s = fixupPrefix(t.image, t.beginLine, t.beginColumn) ;
        getPrologue().setPrefix(s, iri) ;
  }

// ---- Query type clauses
  final public void SelectQuery() throws ParseException {
    SelectClause();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FROM:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_2;
      }
      DatasetClause();
    }
    WhereClause();
    SolutionModifier();
    BindingsClause();
  }

  final public void SubSelect() throws ParseException {
    SelectClause();
    WhereClause();
    SolutionModifier();
  }

  final public void SelectClause() throws ParseException {
                        Var v ; Expr expr ; Node n ;
    jj_consume_token(SELECT);
      getQuery().setQuerySelectType() ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DISTINCT:
    case REDUCED:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DISTINCT:
        jj_consume_token(DISTINCT);
                 getQuery().setDistinct(true);
        break;
      case REDUCED:
        jj_consume_token(REDUCED);
                getQuery().setReduced(true);
        break;
      default:
        jj_la1[5] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[6] = jj_gen;
      ;
    }
    allowAggregatesInExpressions = true ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VAR1:
    case VAR2:
    case LPAREN:
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case VAR1:
        case VAR2:
          v = Var();
                  getQuery().addResultVar(v) ;
          break;
        case LPAREN:
          v = null ;
          jj_consume_token(LPAREN);
          expr = Expression();
          jj_consume_token(AS);
          v = Var();
          jj_consume_token(RPAREN);
          getQuery().addResultVar(v, expr) ;
        getQuery().setQueryResultStar(false) ;
          break;
        default:
          jj_la1[7] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case VAR1:
        case VAR2:
        case LPAREN:
          ;
          break;
        default:
          jj_la1[8] = jj_gen;
          break label_3;
        }
      }
      break;
    case STAR:
      jj_consume_token(STAR);
             getQuery().setQueryResultStar(true) ;
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    allowAggregatesInExpressions = false ;
  }

  final public void ConstructQuery() throws ParseException {
                          Template t ;
    jj_consume_token(CONSTRUCT);
      getQuery().setQueryConstructType() ;
    t = ConstructTemplate();
      getQuery().setQueryResultStar(false) ;
      getQuery().setConstructTemplate(t) ;
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FROM:
        ;
        break;
      default:
        jj_la1[10] = jj_gen;
        break label_4;
      }
      DatasetClause();
    }
    WhereClause();
    SolutionModifier();
  }

  final public void DescribeQuery() throws ParseException {
                         Node n ;
    jj_consume_token(DESCRIBE);
      getQuery().setQueryDescribeType() ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case VAR1:
    case VAR2:
      label_5:
      while (true) {
        n = VarOrIRIref();
                          getQuery().addDescribeNode(n) ;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IRIref:
        case PNAME_NS:
        case PNAME_LN:
        case VAR1:
        case VAR2:
          ;
          break;
        default:
          jj_la1[11] = jj_gen;
          break label_5;
        }
      }
      getQuery().setQueryResultStar(false) ;
      break;
    case STAR:
      jj_consume_token(STAR);
      getQuery().setQueryResultStar(true) ;
      break;
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FROM:
        ;
        break;
      default:
        jj_la1[13] = jj_gen;
        break label_6;
      }
      DatasetClause();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
    case LBRACE:
      WhereClause();
      break;
    default:
      jj_la1[14] = jj_gen;
      ;
    }
    SolutionModifier();
  }

  final public void AskQuery() throws ParseException {
    jj_consume_token(ASK);
          getQuery().setQueryAskType() ;
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FROM:
        ;
        break;
      default:
        jj_la1[15] = jj_gen;
        break label_7;
      }
      DatasetClause();
    }
    WhereClause();
  }

// ----
  final public void DatasetClause() throws ParseException {
    jj_consume_token(FROM);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
      DefaultGraphClause();
      break;
    case NAMED:
      NamedGraphClause();
      break;
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void DefaultGraphClause() throws ParseException {
                              String iri ;
    iri = SourceSelector();
    // This checks for duplicates
    getQuery().addGraphURI(iri) ;
  }

  final public void NamedGraphClause() throws ParseException {
                            String iri ;
    jj_consume_token(NAMED);
    iri = SourceSelector();
    // This checks for duplicates
    getQuery().addNamedGraphURI(iri) ;
  }

  final public String SourceSelector() throws ParseException {
                            String iri ;
    iri = IRIref();
                   {if (true) return iri ;}
    throw new Error("Missing return statement in function");
  }

  final public void WhereClause() throws ParseException {
                       Element el ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      jj_consume_token(WHERE);
      break;
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    el = GroupGraphPattern();
                                         getQuery().setQueryPattern(el) ;
  }

  final public void SolutionModifier() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GROUP:
      GroupClause();
      break;
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HAVING:
      HavingClause();
      break;
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      OrderClause();
      break;
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LIMIT:
    case OFFSET:
      LimitOffsetClauses();
      break;
    default:
      jj_la1[21] = jj_gen;
      ;
    }
  }

  final public void GroupClause() throws ParseException {
    jj_consume_token(GROUP);
    jj_consume_token(BY);
    label_8:
    while (true) {
      GroupCondition();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case VAR1:
      case VAR2:
      case EXISTS:
      case NOTEXISTS:
      case BOUND:
      case COALESCE:
      case IF:
      case BNODE:
      case IRI:
      case URI:
      case STR:
      case STRLANG:
      case STRDT:
      case DTYPE:
      case LANG:
      case LANGMATCHES:
      case IS_URI:
      case IS_IRI:
      case IS_BLANK:
      case IS_LITERAL:
      case REGEX:
      case SAME_TERM:
      case LPAREN:
        ;
        break;
      default:
        jj_la1[22] = jj_gen;
        break label_8;
      }
    }
  }

  final public void GroupCondition() throws ParseException {
                          Var v = null ; Expr expr = null ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXISTS:
    case NOTEXISTS:
    case BOUND:
    case COALESCE:
    case IF:
    case BNODE:
    case IRI:
    case URI:
    case STR:
    case STRLANG:
    case STRDT:
    case DTYPE:
    case LANG:
    case LANGMATCHES:
    case IS_URI:
    case IS_IRI:
    case IS_BLANK:
    case IS_LITERAL:
    case REGEX:
    case SAME_TERM:
      expr = BuiltInCall();
                           getQuery().addGroupBy((Var)null, expr) ;
      break;
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
      expr = FunctionCall();
                            getQuery().addGroupBy((Var)null, expr) ;
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      expr = Expression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        v = Var();
        break;
      default:
        jj_la1[23] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
      getQuery().addGroupBy(v ,expr) ;
      break;
    case VAR1:
    case VAR2:
      v = Var();
      getQuery().addGroupBy(v) ;
      break;
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void HavingClause() throws ParseException {
      allowAggregatesInExpressions = true ;
    jj_consume_token(HAVING);
    label_9:
    while (true) {
      HavingCondition();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case EXISTS:
      case NOTEXISTS:
      case BOUND:
      case COALESCE:
      case IF:
      case BNODE:
      case IRI:
      case URI:
      case STR:
      case STRLANG:
      case STRDT:
      case DTYPE:
      case LANG:
      case LANGMATCHES:
      case IS_URI:
      case IS_IRI:
      case IS_BLANK:
      case IS_LITERAL:
      case REGEX:
      case SAME_TERM:
      case LPAREN:
        ;
        break;
      default:
        jj_la1[25] = jj_gen;
        break label_9;
      }
    }
      allowAggregatesInExpressions = false ;
  }

  final public void HavingCondition() throws ParseException {
                           Expr c ;
    c = Constraint();
     getQuery().addHavingCondition(c) ;
  }

  final public void OrderClause() throws ParseException {
    jj_consume_token(ORDER);
    jj_consume_token(BY);
    label_10:
    while (true) {
      OrderCondition();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case VAR1:
      case VAR2:
      case ASC:
      case DESC:
      case EXISTS:
      case NOTEXISTS:
      case BOUND:
      case COALESCE:
      case IF:
      case BNODE:
      case IRI:
      case URI:
      case STR:
      case STRLANG:
      case STRDT:
      case DTYPE:
      case LANG:
      case LANGMATCHES:
      case IS_URI:
      case IS_IRI:
      case IS_BLANK:
      case IS_LITERAL:
      case REGEX:
      case SAME_TERM:
      case LPAREN:
        ;
        break;
      default:
        jj_la1[26] = jj_gen;
        break label_10;
      }
    }
  }

  final public void OrderCondition() throws ParseException {
  int direction = 0 ; Expr expr = null ; Node v = null ;
    direction = Query.ORDER_DEFAULT ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASC:
    case DESC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASC:
        jj_consume_token(ASC);
                direction = Query.ORDER_ASCENDING ;
        break;
      case DESC:
        jj_consume_token(DESC);
                 direction = Query.ORDER_DESCENDING ;
        break;
      default:
        jj_la1[27] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expr = BrackettedExpression();
      break;
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case VAR1:
    case VAR2:
    case EXISTS:
    case NOTEXISTS:
    case BOUND:
    case COALESCE:
    case IF:
    case BNODE:
    case IRI:
    case URI:
    case STR:
    case STRLANG:
    case STRDT:
    case DTYPE:
    case LANG:
    case LANGMATCHES:
    case IS_URI:
    case IS_IRI:
    case IS_BLANK:
    case IS_LITERAL:
    case REGEX:
    case SAME_TERM:
    case LPAREN:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case EXISTS:
      case NOTEXISTS:
      case BOUND:
      case COALESCE:
      case IF:
      case BNODE:
      case IRI:
      case URI:
      case STR:
      case STRLANG:
      case STRDT:
      case DTYPE:
      case LANG:
      case LANGMATCHES:
      case IS_URI:
      case IS_IRI:
      case IS_BLANK:
      case IS_LITERAL:
      case REGEX:
      case SAME_TERM:
      case LPAREN:
        expr = Constraint();
        break;
      case VAR1:
      case VAR2:
        v = Var();
        break;
      default:
        jj_la1[28] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[29] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if ( v == null )
          getQuery().addOrderBy(expr, direction) ;
      else
          getQuery().addOrderBy(v, direction) ;
  }

  final public void LimitOffsetClauses() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LIMIT:
      LimitClause();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OFFSET:
        OffsetClause();
        break;
      default:
        jj_la1[30] = jj_gen;
        ;
      }
      break;
    case OFFSET:
      OffsetClause();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LIMIT:
        LimitClause();
        break;
      default:
        jj_la1[31] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[32] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void LimitClause() throws ParseException {
                       Token t ;
    jj_consume_token(LIMIT);
    t = jj_consume_token(INTEGER);
      getQuery().setLimit(integerValue(t.image)) ;
  }

  final public void OffsetClause() throws ParseException {
                        Token t ;
    jj_consume_token(OFFSET);
    t = jj_consume_token(INTEGER);
      getQuery().setOffset(integerValue(t.image)) ;
  }

  final public void BindingsClause() throws ParseException {
                          Var v ; Node n ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BINDINGS:
      jj_consume_token(BINDINGS);
      label_11:
      while (true) {
        v = Var();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case VAR1:
        case VAR2:
          ;
          break;
        default:
          jj_la1[33] = jj_gen;
          break label_11;
        }
      }
      jj_consume_token(LBRACE);
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
          ;
          break;
        default:
          jj_la1[34] = jj_gen;
          break label_12;
        }
        jj_consume_token(LPAREN);
        label_13:
        while (true) {
          n = BindingValue();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case IRIref:
          case PNAME_NS:
          case PNAME_LN:
          case UNDEF:
          case TRUE:
          case FALSE:
          case INTEGER:
          case DECIMAL:
          case DOUBLE:
          case INTEGER_POSITIVE:
          case DECIMAL_POSITIVE:
          case DOUBLE_POSITIVE:
          case INTEGER_NEGATIVE:
          case DECIMAL_NEGATIVE:
          case DOUBLE_NEGATIVE:
          case STRING_LITERAL1:
          case STRING_LITERAL2:
          case STRING_LITERAL_LONG1:
          case STRING_LITERAL_LONG2:
            ;
            break;
          default:
            jj_la1[35] = jj_gen;
            break label_13;
          }
        }
        jj_consume_token(RPAREN);
      }
      jj_consume_token(RBRACE);
      break;
    default:
      jj_la1[36] = jj_gen;
      ;
    }
  }

  final public Node BindingValue() throws ParseException {
                        Node n ; String iri ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
      iri = IRIref();
                   {if (true) return createNode(iri) ;}
      break;
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
      n = RDFLiteral();
                     {if (true) return n ;}
      break;
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
      n = NumericLiteral();
                         {if (true) return n ;}
      break;
    case TRUE:
    case FALSE:
      n = BooleanLiteral();
                         {if (true) return n ;}
      break;
    case UNDEF:
      jj_consume_token(UNDEF);
            {if (true) return null ;}
      break;
    default:
      jj_la1[37] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// ---- SPARQL/Update (submission)


// Update only entry point
  final public void UpdateUnit() throws ParseException {
    Prologue();
    Update();
    jj_consume_token(0);
  }

  final public void Update() throws ParseException {
    label_14:
    while (true) {
      Update1();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INSERT:
      case DELETE:
      case LOAD:
      case CLEAR:
      case CREATE:
      case DROP:
      case WITH:
        ;
        break;
      default:
        jj_la1[38] = jj_gen;
        break label_14;
      }
    }
  }

// SPARQL 1.1 Update
  final public void Update1() throws ParseException {
                   Update up = null ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSERT:
    case DELETE:
    case WITH:
      Modify();
      break;
    case LOAD:
      Load();
      break;
    case CLEAR:
      Clear();
      break;
    case DROP:
      Drop();
      break;
    case CREATE:
      Create();
      break;
    default:
      jj_la1[39] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[40] = jj_gen;
      ;
    }
  }

  final public void Modify() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
      jj_consume_token(WITH);
      IRIref();
      break;
    default:
      jj_la1[41] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSERT:
      Insert();
      break;
    case DELETE:
      Delete();
      break;
    default:
      jj_la1[42] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void Insert() throws ParseException {
    jj_consume_token(INSERT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATA:
      jj_consume_token(DATA);
      QuadData();
      break;
    case LBRACE:
      QuadTemplate();
      jj_consume_token(WHERE);
      GroupGraphPattern();
      break;
    default:
      jj_la1[43] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void Delete() throws ParseException {
    jj_consume_token(DELETE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATA:
      jj_consume_token(DATA);
      QuadData();
      break;
    case WHERE:
      jj_consume_token(WHERE);
      QuadTemplate();
      break;
    case LBRACE:
      QuadTemplate();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INSERT:
        jj_consume_token(INSERT);
        QuadTemplate();
        break;
      default:
        jj_la1[44] = jj_gen;
        ;
      }
      jj_consume_token(WHERE);
      GroupGraphPattern();
      break;
    default:
      jj_la1[45] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void Clear() throws ParseException {
    jj_consume_token(CLEAR);
    GraphRef();
  }

  final public void Load() throws ParseException {
    jj_consume_token(LOAD);
    label_15:
    while (true) {
      IRIref();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
        ;
        break;
      default:
        jj_la1[46] = jj_gen;
        break label_15;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTO:
      jj_consume_token(INTO);
      GraphRef();
      break;
    default:
      jj_la1[47] = jj_gen;
      ;
    }
  }

  final public void Drop() throws ParseException {
    jj_consume_token(DROP);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SILENT:
      jj_consume_token(SILENT);
      break;
    default:
      jj_la1[48] = jj_gen;
      ;
    }
    IRIref();
  }

  final public void Create() throws ParseException {
    jj_consume_token(CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SILENT:
      jj_consume_token(SILENT);
      break;
    default:
      jj_la1[49] = jj_gen;
      ;
    }
    IRIref();
  }

  final public void GraphRef() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DFT:
      jj_consume_token(DFT);
      break;
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
      IRIref();
      break;
    default:
      jj_la1[50] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void QuadTemplate() throws ParseException {
    jj_consume_token(LBRACE);
    Quads();
    jj_consume_token(RBRACE);
  }

  final public void Quads() throws ParseException {
                 TripleCollector acc = new TemplateGroup() ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:
    case VAR1:
    case VAR2:
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case LPAREN:
    case NIL:
    case LBRACKET:
    case ANON:
      TriplesTemplate(null, acc);
      break;
    default:
      jj_la1[51] = jj_gen;
      ;
    }
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GRAPH:
        ;
        break;
      default:
        jj_la1[52] = jj_gen;
        break label_16;
      }
      QuadsNotTriples(acc);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        jj_consume_token(DOT);
        break;
      default:
        jj_la1[53] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case BLANK_NODE_LABEL:
      case VAR1:
      case VAR2:
      case TRUE:
      case FALSE:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case INTEGER_POSITIVE:
      case DECIMAL_POSITIVE:
      case DOUBLE_POSITIVE:
      case INTEGER_NEGATIVE:
      case DECIMAL_NEGATIVE:
      case DOUBLE_NEGATIVE:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case LPAREN:
      case NIL:
      case LBRACKET:
      case ANON:
        TriplesTemplate(null, acc);
        break;
      default:
        jj_la1[54] = jj_gen;
        ;
      }
    }
  }

// @@ Java broken
  final public void QuadsNotTriples(TripleCollector acc) throws ParseException {
                                             Node n ;
    jj_consume_token(GRAPH);
    n = VarOrIRIref();
    jj_consume_token(LBRACE);
    TriplesTemplate(n, acc);
    jj_consume_token(RBRACE);
  }

  final public void TriplesTemplate(Node g, TripleCollector acc) throws ParseException {
    TriplesSameSubject(acc);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOT:
      jj_consume_token(DOT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case BLANK_NODE_LABEL:
      case VAR1:
      case VAR2:
      case TRUE:
      case FALSE:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case INTEGER_POSITIVE:
      case DECIMAL_POSITIVE:
      case DOUBLE_POSITIVE:
      case INTEGER_NEGATIVE:
      case DECIMAL_NEGATIVE:
      case DOUBLE_NEGATIVE:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case LPAREN:
      case NIL:
      case LBRACKET:
      case ANON:
        TriplesTemplate(g, acc);
        break;
      default:
        jj_la1[55] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[56] = jj_gen;
      ;
    }
  }

//Ground data
// @@
  final public void QuadData() throws ParseException {
    jj_consume_token(LBRACE);
    Quads();
    jj_consume_token(RBRACE);
  }

// UPDATE_SPARQL_11

// UPDATE


// ---- General Graph Pattern 
  final public Element GroupGraphPattern() throws ParseException {
                                Element el = null ; Token t ;
    t = jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
      startSubSelect() ;
      SubSelect();
      Query q = endSubSelect(t.beginLine, t.beginColumn) ;
      el = new ElementSubQuery(q) ;
      break;
    default:
      jj_la1[57] = jj_gen;
      el = GroupGraphPatternSub();
    }
    jj_consume_token(RBRACE);
      {if (true) return el ;}
    throw new Error("Missing return statement in function");
  }

  final public Element GroupGraphPatternSub() throws ParseException {
                                   Element el = null ;
        ElementGroup elg = new ElementGroup() ;
        startGroup(elg) ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:
    case VAR1:
    case VAR2:
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case LPAREN:
    case NIL:
    case LBRACKET:
    case ANON:
      startTriplesBlock() ;
      el = TriplesBlock(null);
      endTriplesBlock() ;
      elg.addElement(el) ;
      break;
    default:
      jj_la1[58] = jj_gen;
      ;
    }
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GRAPH:
      case OPTIONAL:
      case UNION:
      case SERVICE:
      case MINUS_P:
      case FILTER:
      case LBRACE:
        ;
        break;
      default:
        jj_la1[59] = jj_gen;
        break label_17;
      }
      el = GraphPatternNotTriples();
      elg.addElement(el) ;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        jj_consume_token(DOT);
        break;
      default:
        jj_la1[60] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case BLANK_NODE_LABEL:
      case VAR1:
      case VAR2:
      case TRUE:
      case FALSE:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case INTEGER_POSITIVE:
      case DECIMAL_POSITIVE:
      case DOUBLE_POSITIVE:
      case INTEGER_NEGATIVE:
      case DECIMAL_NEGATIVE:
      case DOUBLE_NEGATIVE:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case LPAREN:
      case NIL:
      case LBRACKET:
      case ANON:
        startTriplesBlock() ;
        el = TriplesBlock(null);
        endTriplesBlock() ;
        elg.addElement(el) ;
        break;
      default:
        jj_la1[61] = jj_gen;
        ;
      }
    }
        endGroup(elg) ;
        {if (true) return elg ;}
    throw new Error("Missing return statement in function");
  }

// -- TriplesBlock
// Two versions - for SPARQL 1.0 and SPARQL 1.1 (with paths)

// #ifdef SPARQL_10
// Element TriplesBlock(ElementTriplesBlock acc) : { }
// {
//   { if ( acc == null )
//         acc = new ElementTriplesBlock() ;
//   }
//   TriplesSameSubject(acc)
//   ( <DOT> (TriplesBlock(acc))? )?
//     { return acc ; }
// }
// #endif
  final public Element TriplesBlock(ElementPathBlock acc) throws ParseException {
    if ( acc == null )
        acc = new ElementPathBlock() ;
    TriplesSameSubjectPath(acc);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOT:
      jj_consume_token(DOT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case BLANK_NODE_LABEL:
      case VAR1:
      case VAR2:
      case TRUE:
      case FALSE:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case INTEGER_POSITIVE:
      case DECIMAL_POSITIVE:
      case DOUBLE_POSITIVE:
      case INTEGER_NEGATIVE:
      case DECIMAL_NEGATIVE:
      case DOUBLE_NEGATIVE:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case LPAREN:
      case NIL:
      case LBRACKET:
      case ANON:
        TriplesBlock(acc);
        break;
      default:
        jj_la1[62] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[63] = jj_gen;
      ;
    }
      {if (true) return acc ;}
    throw new Error("Missing return statement in function");
  }

// -----
  final public Element GraphPatternNotTriples() throws ParseException {
                                     Element el = null ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      el = GroupGraphPattern();
      break;
    case OPTIONAL:
      el = OptionalGraphPattern();
      break;
    case UNION:
      el = UnionGraphPattern();
      break;
    case MINUS_P:
      el = MinusGraphPattern();
      break;
    case GRAPH:
      el = GraphGraphPattern();
      break;
    case SERVICE:
      el = ServiceGraphPattern();
      break;
    case FILTER:
      el = Filter();
      break;
    default:
      jj_la1[64] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
   {if (true) return el ;}
    throw new Error("Missing return statement in function");
  }

// ---- Definitions of each pattern element
  final public Element OptionalGraphPattern() throws ParseException {
                                   Element el ;
    jj_consume_token(OPTIONAL);
    el = GroupGraphPattern();
      {if (true) return new ElementOptional(el) ;}
    throw new Error("Missing return statement in function");
  }

  final public Element GraphGraphPattern() throws ParseException {
                                Element el ; Node n ;
    jj_consume_token(GRAPH);
    n = VarOrIRIref();
    el = GroupGraphPattern();
      {if (true) return new ElementNamedGraph(n, el) ;}
    throw new Error("Missing return statement in function");
  }

  final public Element ServiceGraphPattern() throws ParseException {
                                  Element el ; Node n ;
    jj_consume_token(SERVICE);
    n = VarOrIRIref();
    el = GroupGraphPattern();
      {if (true) return new ElementService(n, el) ;}
    throw new Error("Missing return statement in function");
  }

  final public Element MinusGraphPattern() throws ParseException {
                                Element el ;
    jj_consume_token(MINUS_P);
    el = GroupGraphPattern();
      {if (true) return new ElementMinus(el) ;}
    throw new Error("Missing return statement in function");
  }

  final public Element UnionGraphPattern() throws ParseException {
                                Element el ;
    jj_consume_token(UNION);
    el = GroupGraphPattern();
      {if (true) return new ElementUnion(el) ;}
    throw new Error("Missing return statement in function");
  }

// SPARQL 1.0: {pattern} UNION {pattern} UNION {pattern} ... :: 
// SPARQL 1.1: { pattern UNION pattern UNION ... }

// // G (union G)* can be a single group pattern
// // or a group pattern as part of an union.
// Element GroupOrUnionGraphPattern() :
// { Element el = null ; ElementUnion el2 = null ; }
// {
//   el = GroupGraphPattern()
//   ( <UNION>
//     { if ( el2 == null )
//       {
//         el2 = new ElementUnion() ;
//         el2.addElement(el) ;
//       }
//     }
//   el = GroupGraphPattern()
//     { el2.addElement(el) ; } 
//   )*
//     { return (el2==null)? el : el2 ; }
// }
// 
  final public Element Filter() throws ParseException {
                     Expr c ;
    jj_consume_token(FILTER);
    c = Constraint();
    {if (true) return new ElementFilter(c) ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr Constraint() throws ParseException {
                      Expr c ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      c = BrackettedExpression();
      break;
    case EXISTS:
    case NOTEXISTS:
    case BOUND:
    case COALESCE:
    case IF:
    case BNODE:
    case IRI:
    case URI:
    case STR:
    case STRLANG:
    case STRDT:
    case DTYPE:
    case LANG:
    case LANGMATCHES:
    case IS_URI:
    case IS_IRI:
    case IS_BLANK:
    case IS_LITERAL:
    case REGEX:
    case SAME_TERM:
      c = BuiltInCall();
      break;
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
      c = FunctionCall();
      break;
    default:
      jj_la1[65] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return c ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr FunctionCall() throws ParseException {
                        String fname ; ExprList a ;
    fname = IRIref();
    a = ArgList();
    {if (true) return new E_Function(fname, a) ;}
    throw new Error("Missing return statement in function");
  }

  final public ExprList ArgList() throws ParseException {
                       Expr expr ; boolean distinct = false ;
                      ExprList args = new ExprList() ; Token t ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NIL:
      jj_consume_token(NIL);
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DISTINCT:
        t = jj_consume_token(DISTINCT);
                        distinct = true ;
          if ( ! allowAggregatesInExpressions )
              throwParseException("Aggregate expression not legal at this point",
                                 t.beginLine, t.beginColumn) ;
        break;
      default:
        jj_la1[66] = jj_gen;
        ;
      }
      expr = Expression();
                            args.add(expr) ;
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[67] = jj_gen;
          break label_18;
        }
        jj_consume_token(COMMA);
        expr = Expression();
                                     args.add(expr) ;
      }
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[68] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return args ;}
    throw new Error("Missing return statement in function");
  }

// ExprList Params() : { Expr expr ;  ExprList args = new ExprList() ; Token t = null ; }
// { 
//   // "; name=expr ..."
//   t = <SEMICOLON>
//   {
//     if ( ! allowAggregatesInExpressions )
//           throwParseException("Aggregate expression not legal at this point",
//                                t.beginLine, t.beginColumn) ;
//   }
//   (
//     expr = Expression() { args.add(expr) ; } 
//     (<COMMA> expr = Expression() { args.add(expr) ; } )*
//   )?
//   { return args ; }
// }

// Singe expression aggregate argument
  final public Expr ExprAggArg() throws ParseException {
                      Expr expr = null ; boolean distinct = false ; Token t ;
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DISTINCT:
      t = jj_consume_token(DISTINCT);
                     distinct = true ;
     if ( ! allowAggregatesInExpressions )
          throwParseException("Aggregate expression not legal at this point",
                              t.beginLine, t.beginColumn) ;
      break;
    default:
      jj_la1[69] = jj_gen;
      ;
    }
    expr = Expression();
    jj_consume_token(RPAREN);
    {if (true) return expr ;}
    throw new Error("Missing return statement in function");
  }

  final public ExprList ExpressionList() throws ParseException {
                              Expr expr = null ; ExprList args = new ExprList() ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NIL:
      jj_consume_token(NIL);
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      expr = Expression();
                          args.add(expr) ;
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[70] = jj_gen;
          break label_19;
        }
        jj_consume_token(COMMA);
        expr = Expression();
                                     args.add(expr) ;
      }
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[71] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return args ;}
    throw new Error("Missing return statement in function");
  }

// -------- Construct patterns
  final public Template ConstructTemplate() throws ParseException {
      setInConstructTemplate(true) ;
      TemplateGroup g = new TemplateGroup() ;
    jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:
    case VAR1:
    case VAR2:
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case LPAREN:
    case NIL:
    case LBRACKET:
    case ANON:
      ConstructTriples(g);
      break;
    default:
      jj_la1[72] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
      setInConstructTemplate(false) ;
      {if (true) return g ;}
    throw new Error("Missing return statement in function");
  }

  final public void ConstructTriples(TemplateGroup acc) throws ParseException {
    TriplesSameSubject(acc);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOT:
      jj_consume_token(DOT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case BLANK_NODE_LABEL:
      case VAR1:
      case VAR2:
      case TRUE:
      case FALSE:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case INTEGER_POSITIVE:
      case DECIMAL_POSITIVE:
      case DOUBLE_POSITIVE:
      case INTEGER_NEGATIVE:
      case DECIMAL_NEGATIVE:
      case DOUBLE_NEGATIVE:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case LPAREN:
      case NIL:
      case LBRACKET:
      case ANON:
        ConstructTriples(acc);
        break;
      default:
        jj_la1[73] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[74] = jj_gen;
      ;
    }
  }

// -------- Triple lists with property and object lists
// -------- Without paths: entry: TriplesSameSubject
  final public void TriplesSameSubject(TripleCollector acc) throws ParseException {
                                                 Node s ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:
    case VAR1:
    case VAR2:
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case NIL:
    case ANON:
      s = VarOrTerm();
      PropertyListNotEmpty(s, acc);
      break;
    case LPAREN:
    case LBRACKET:
      // Any of the triple generating syntax elements
        s = TriplesNode(acc);
      PropertyList(s, acc);
      break;
    default:
      jj_la1[75] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void PropertyListNotEmpty(Node s, TripleCollector acc) throws ParseException {
      Node p = null ;
    p = Verb();
    ObjectList(s, p, null, acc);
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        ;
        break;
      default:
        jj_la1[76] = jj_gen;
        break label_20;
      }
      jj_consume_token(SEMICOLON);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case VAR1:
      case VAR2:
      case KW_A:
        p = Verb();
        ObjectList(s, p, null, acc);
        break;
      default:
        jj_la1[77] = jj_gen;
        ;
      }
    }
  }

  final public void PropertyList(Node s, TripleCollector acc) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case VAR1:
    case VAR2:
    case KW_A:
      PropertyListNotEmpty(s, acc);
      break;
    default:
      jj_la1[78] = jj_gen;
      ;
    }
  }

  final public void ObjectList(Node s, Node p, Path path, TripleCollector acc) throws ParseException {
                                                                   Node o ;
    Object(s, p, path, acc);
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[79] = jj_gen;
        break label_21;
      }
      jj_consume_token(COMMA);
      Object(s, p, path, acc);
    }
  }

  final public void Object(Node s, Node p, Path path, TripleCollector acc) throws ParseException {
                                                               Node o ;
      int mark = acc.mark() ;
    o = GraphNode(acc);
    insert(acc, mark, s, p, path, o) ;
  }

  final public Node Verb() throws ParseException {
                Node p ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case VAR1:
    case VAR2:
      p = VarOrIRIref();
      break;
    case KW_A:
      jj_consume_token(KW_A);
                                 p = nRDFtype ;
      break;
    default:
      jj_la1[80] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return p ;}
    throw new Error("Missing return statement in function");
  }

// -------- BGPs with paths.
// -------- Entry point: TriplesSameSubjectPath
  final public void TriplesSameSubjectPath(TripleCollector acc) throws ParseException {
                                                     Node s ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:
    case VAR1:
    case VAR2:
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case NIL:
    case ANON:
      s = VarOrTerm();
      PropertyListNotEmptyPath(s, acc);
      break;
    case LPAREN:
    case LBRACKET:
      // Any of the triple generating syntax elements
        s = TriplesNode(acc);
      PropertyListPath(s, acc);
      break;
    default:
      jj_la1[81] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void PropertyListNotEmptyPath(Node s, TripleCollector acc) throws ParseException {
      Path path = null ; Node p = null ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case KW_A:
    case LPAREN:
    case BANG:
    case CARAT:
      path = VerbPath();
      break;
    case VAR1:
    case VAR2:
      p = VerbSimple();
      break;
    default:
      jj_la1[82] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    ObjectList(s, p, path, acc);
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        ;
        break;
      default:
        jj_la1[83] = jj_gen;
        break label_22;
      }
      jj_consume_token(SEMICOLON);
      path = null ; p = null ;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case VAR1:
      case VAR2:
      case KW_A:
      case LPAREN:
      case BANG:
      case CARAT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IRIref:
        case PNAME_NS:
        case PNAME_LN:
        case KW_A:
        case LPAREN:
        case BANG:
        case CARAT:
          path = VerbPath();
          break;
        case VAR1:
        case VAR2:
          p = VerbSimple();
          break;
        default:
          jj_la1[84] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        ObjectList(s, p, path, acc);
        break;
      default:
        jj_la1[85] = jj_gen;
        ;
      }
    }
  }

  final public void PropertyListPath(Node s, TripleCollector acc) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case VAR1:
    case VAR2:
    case KW_A:
      PropertyListNotEmpty(s, acc);
      break;
    default:
      jj_la1[86] = jj_gen;
      ;
    }
  }

  final public Path VerbPath() throws ParseException {
                   Node p ; Path path ;
    path = Path();
                  {if (true) return path ;}
    throw new Error("Missing return statement in function");
  }

  final public Node VerbSimple() throws ParseException {
                      Node p ;
    // "a" now allowed in paths.
      //( p = Var() | <KW_A> { p = nRDFtype ; } )
      p = Var();
    {if (true) return p ;}
    throw new Error("Missing return statement in function");
  }

// End paths stuff.

// -------- Paths
// Weakest outermost
  final public Path Path() throws ParseException {
                Path p ;
    p = PathAlternative();
                          {if (true) return p ;}
    throw new Error("Missing return statement in function");
  }

  final public Path PathAlternative() throws ParseException {
                           Path p1 , p2 ;
    p1 = PathSequence();
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VBAR:
        ;
        break;
      default:
        jj_la1[87] = jj_gen;
        break label_23;
      }
      jj_consume_token(VBAR);
      p2 = PathSequence();
        p1 = new P_Alt(p1, p2) ;
    }
     {if (true) return p1 ;}
    throw new Error("Missing return statement in function");
  }

  final public Path PathSequence() throws ParseException {
                        Path p1 , p2 ;
    p1 = PathEltOrInverse();
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SLASH:
      case CARAT:
        ;
        break;
      default:
        jj_la1[88] = jj_gen;
        break label_24;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SLASH:
        jj_consume_token(SLASH);
        p2 = PathEltOrInverse();
        p1 = new P_Seq(p1, p2) ;
        break;
      case CARAT:
        jj_consume_token(CARAT);
        p2 = PathElt();
        p1 = new P_Seq(p1, new P_Inverse(p2)) ;
        break;
      default:
        jj_la1[89] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
     {if (true) return p1;}
    throw new Error("Missing return statement in function");
  }

// Path unit element, no inverse
  final public Path PathElt() throws ParseException {
                   String str ; Node n ; Path p ;
    p = PathPrimary();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
    case PLUS:
    case STAR:
    case QMARK:
      p = PathMod(p);
      break;
    default:
      jj_la1[90] = jj_gen;
      ;
    }
     {if (true) return p ;}
    throw new Error("Missing return statement in function");
  }

// Path unit element, including inverse.
  final public Path PathEltOrInverse() throws ParseException {
                            String str ; Node n ; Path p ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case KW_A:
    case LPAREN:
    case BANG:
      p = PathElt();
      break;
    case CARAT:
      jj_consume_token(CARAT);
      p = PathElt();
       p = new P_Inverse(p) ;
      break;
    default:
      jj_la1[91] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     {if (true) return p ;}
    throw new Error("Missing return statement in function");
  }

  final public Path PathMod(Path p) throws ParseException {
                         long i1 = UNSET ; long i2 = UNSET ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STAR:
      jj_consume_token(STAR);
              {if (true) return PathFactory.modZeroOrMode(p) ;}
      break;
    case QMARK:
      jj_consume_token(QMARK);
               {if (true) return PathFactory.modZeroOrOne(p) ;}
      break;
    case PLUS:
      jj_consume_token(PLUS);
              {if (true) return PathFactory.modOneOrMore(p) ;}
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
      // {N} {N,M} {N,}
                  i1 = Integer();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case RBRACE:
          jj_consume_token(RBRACE);
                      {if (true) return new P_Mod(p, i1, INF) ;}
          break;
        case INTEGER:
          i2 = Integer();
          jj_consume_token(RBRACE);
                      {if (true) return new P_Mod(p, i1, i2) ;}
          break;
        default:
          jj_la1[92] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      case RBRACE:
        jj_consume_token(RBRACE);
                       {if (true) return new P_Mod(p, i1) ;}
        break;
      default:
        jj_la1[93] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[94] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Path PathPrimary() throws ParseException {
                       String str ; Path p ; Node n ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
      str = IRIref();
       n = createNode(str) ; p = new P_Link(n) ;
      break;
    case KW_A:
      jj_consume_token(KW_A);
       p = new P_Link(nRDFtype) ;
      break;
    case BANG:
      jj_consume_token(BANG);
      p = PathNegatedPropertyClass();
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      p = Path();
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[95] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return p ;}
    throw new Error("Missing return statement in function");
  }

  final public Path PathNegatedPropertyClass() throws ParseException {
                                    P_Path0 p ; P_NegPropClass pNegClass ;
    pNegClass = new P_NegPropClass() ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case KW_A:
      p = PathOneInPropertyClass();
      pNegClass.add(p) ;
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case KW_A:
        p = PathOneInPropertyClass();
                                     pNegClass.add(p) ;
        label_25:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case VBAR:
            ;
            break;
          default:
            jj_la1[96] = jj_gen;
            break label_25;
          }
          jj_consume_token(VBAR);
          p = PathOneInPropertyClass();
                                             pNegClass.add(p) ;
        }
        break;
      default:
        jj_la1[97] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[98] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return pNegClass ;}
    throw new Error("Missing return statement in function");
  }

  final public P_Path0 PathOneInPropertyClass() throws ParseException {
                                     String str ; Node n ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
      str = IRIref();
                     n = createNode(str) ; {if (true) return new P_Link(n) ;}
      break;
    case KW_A:
      jj_consume_token(KW_A);
             {if (true) return new P_Link(nRDFtype) ;}
      break;
    default:
      jj_la1[99] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public long Integer() throws ParseException {
                  Token t ;
    t = jj_consume_token(INTEGER);
      {if (true) return integerValue(t.image) ;}
    throw new Error("Missing return statement in function");
  }

// -------- Triple expansions

// Anything that can stand in a node slot and which is
// a number of triples
  final public Node TriplesNode(TripleCollector acc) throws ParseException {
                                          Node n ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      n = Collection(acc);
                        {if (true) return n ;}
      break;
    case LBRACKET:
      n = BlankNodePropertyList(acc);
                                   {if (true) return n ;}
      break;
    default:
      jj_la1[100] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node BlankNodePropertyList(TripleCollector acc) throws ParseException {
    jj_consume_token(LBRACKET);
      Node n = createBNode() ;
    PropertyListNotEmpty(n, acc);
    jj_consume_token(RBRACKET);
      {if (true) return n ;}
    throw new Error("Missing return statement in function");
  }

// ------- RDF collections
  final public Node Collection(TripleCollector acc) throws ParseException {
      Node listHead = nRDFnil ; Node lastCell = null ; int mark ; Node n ;
    jj_consume_token(LPAREN);
    label_26:
    while (true) {
      Node cell = createListNode() ;
      if ( listHead == nRDFnil )
         listHead = cell ;
      if ( lastCell != null )
        insert(acc, lastCell, nRDFrest, cell) ;
      mark = acc.mark() ;
      n = GraphNode(acc);
      insert(acc, mark, cell, nRDFfirst, n) ;
      lastCell = cell ;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case BLANK_NODE_LABEL:
      case VAR1:
      case VAR2:
      case TRUE:
      case FALSE:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case INTEGER_POSITIVE:
      case DECIMAL_POSITIVE:
      case DOUBLE_POSITIVE:
      case INTEGER_NEGATIVE:
      case DECIMAL_NEGATIVE:
      case DOUBLE_NEGATIVE:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case LPAREN:
      case NIL:
      case LBRACKET:
      case ANON:
        ;
        break;
      default:
        jj_la1[101] = jj_gen;
        break label_26;
      }
    }
    jj_consume_token(RPAREN);
     if ( lastCell != null )
       insert(acc, lastCell, nRDFrest, nRDFnil) ;
     {if (true) return listHead ;}
    throw new Error("Missing return statement in function");
  }

// -------- Nodes in a graph pattern or template
  final public Node GraphNode(TripleCollector acc) throws ParseException {
                                        Node n ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:
    case VAR1:
    case VAR2:
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case NIL:
    case ANON:
      n = VarOrTerm();
                    {if (true) return n ;}
      break;
    case LPAREN:
    case LBRACKET:
      n = TriplesNode(acc);
                         {if (true) return n ;}
      break;
    default:
      jj_la1[102] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node VarOrTerm() throws ParseException {
                    Node n = null ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VAR1:
    case VAR2:
      n = Var();
      break;
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case NIL:
    case ANON:
      n = GraphTerm();
      break;
    default:
      jj_la1[103] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return n ;}
    throw new Error("Missing return statement in function");
  }

// Property (if no bNodes) + DESCRIBE
  final public Node VarOrIRIref() throws ParseException {
                      Node n = null ; String iri ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VAR1:
    case VAR2:
      n = Var();
      break;
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
      iri = IRIref();
                                 n = createNode(iri) ;
      break;
    default:
      jj_la1[104] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return n ;}
    throw new Error("Missing return statement in function");
  }

  final public Var Var() throws ParseException {
              Token t ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VAR1:
      t = jj_consume_token(VAR1);
      break;
    case VAR2:
      t = jj_consume_token(VAR2);
      break;
    default:
      jj_la1[105] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return createVariable(t.image, t.beginLine, t.beginColumn) ;}
    throw new Error("Missing return statement in function");
  }

  final public Node GraphTerm() throws ParseException {
                     Node n ; String iri ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
      iri = IRIref();
                   {if (true) return createNode(iri) ;}
      break;
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
      n = RDFLiteral();
                     {if (true) return n ;}
      break;
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
      n = NumericLiteral();
                         {if (true) return n ;}
      break;
    case TRUE:
    case FALSE:
      n = BooleanLiteral();
                         {if (true) return n ;}
      break;
    case BLANK_NODE_LABEL:
    case ANON:
      n = BlankNode();
                    {if (true) return n ;}
      break;
    case NIL:
      jj_consume_token(NIL);
          {if (true) return nRDFnil ;}
      break;
    default:
      jj_la1[106] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// -------- Constraint syntax
  final public Expr Expression() throws ParseException {
                      Expr expr ;
    expr = ConditionalOrExpression();
    {if (true) return expr ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr ConditionalOrExpression() throws ParseException {
                                   Expr expr1, expr2 ;
    expr1 = ConditionalAndExpression();
    label_27:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SC_OR:
        ;
        break;
      default:
        jj_la1[107] = jj_gen;
        break label_27;
      }
      jj_consume_token(SC_OR);
      expr2 = ConditionalAndExpression();
      expr1 = new E_LogicalOr(expr1, expr2) ;
    }
      {if (true) return expr1 ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr ConditionalAndExpression() throws ParseException {
                                    Expr expr1, expr2 ;
    expr1 = ValueLogical();
    label_28:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SC_AND:
        ;
        break;
      default:
        jj_la1[108] = jj_gen;
        break label_28;
      }
      jj_consume_token(SC_AND);
      expr2 = ValueLogical();
      expr1 = new E_LogicalAnd(expr1, expr2) ;
    }
      {if (true) return expr1 ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr ValueLogical() throws ParseException {
                        Expr expr ;
    expr = RelationalExpression();
      {if (true) return expr ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr RelationalExpression() throws ParseException {
                                Expr expr1, expr2 ; ExprList a ;
    expr1 = NumericExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IN:
    case NOT_IN:
    case EQ:
    case NE:
    case GT:
    case LT:
    case LE:
    case GE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
        jj_consume_token(EQ);
        expr2 = NumericExpression();
        expr1 = new E_Equals(expr1, expr2) ;
        break;
      case NE:
        jj_consume_token(NE);
        expr2 = NumericExpression();
        expr1 = new E_NotEquals(expr1, expr2) ;
        break;
      case LT:
        jj_consume_token(LT);
        expr2 = NumericExpression();
        expr1 = new E_LessThan(expr1, expr2) ;
        break;
      case GT:
        jj_consume_token(GT);
        expr2 = NumericExpression();
        expr1 = new E_GreaterThan(expr1, expr2) ;
        break;
      case LE:
        jj_consume_token(LE);
        expr2 = NumericExpression();
        expr1 = new E_LessThanOrEqual(expr1, expr2) ;
        break;
      case GE:
        jj_consume_token(GE);
        expr2 = NumericExpression();
        expr1 = new E_GreaterThanOrEqual(expr1, expr2) ;
        break;
      case IN:
        jj_consume_token(IN);
        a = ExpressionList();
        expr1 = new E_OneOf(expr1, a) ;
        break;
      case NOT_IN:
        jj_consume_token(NOT_IN);
        a = ExpressionList();
        expr1 = new E_NotOneOf(expr1, a) ;
        break;
      default:
        jj_la1[109] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[110] = jj_gen;
      ;
    }
      {if (true) return expr1 ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr NumericExpression() throws ParseException {
                              Expr expr ;
    expr = AdditiveExpression();
      {if (true) return expr ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr AdditiveExpression() throws ParseException {
                              Expr expr1, expr2, expr3 ; boolean addition ; Node n ;
    expr1 = MultiplicativeExpression();
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_POSITIVE:
      case DECIMAL_POSITIVE:
      case DOUBLE_POSITIVE:
      case INTEGER_NEGATIVE:
      case DECIMAL_NEGATIVE:
      case DOUBLE_NEGATIVE:
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[111] = jj_gen;
        break label_29;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
        expr2 = MultiplicativeExpression();
      expr1 = new E_Add(expr1, expr2) ;
        break;
      case MINUS:
        jj_consume_token(MINUS);
        expr2 = MultiplicativeExpression();
      expr1 = new E_Subtract(expr1, expr2) ;
        break;
      case INTEGER_POSITIVE:
      case DECIMAL_POSITIVE:
      case DOUBLE_POSITIVE:
      case INTEGER_NEGATIVE:
      case DECIMAL_NEGATIVE:
      case DOUBLE_NEGATIVE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTEGER_POSITIVE:
        case DECIMAL_POSITIVE:
        case DOUBLE_POSITIVE:
          n = NumericLiteralPositive();
         n = stripSign(n) ;
         expr2 = asExpr(n) ;
         addition = true ;
          break;
        case INTEGER_NEGATIVE:
        case DECIMAL_NEGATIVE:
        case DOUBLE_NEGATIVE:
          n = NumericLiteralNegative();
         n = stripSign(n) ;
         expr2 = asExpr(n) ;
         addition = false ;
          break;
        default:
          jj_la1[112] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STAR:
        case SLASH:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case STAR:
            jj_consume_token(STAR);
            expr3 = UnaryExpression();
                                           expr2 = new E_Multiply(expr2, expr3) ;
            break;
          case SLASH:
            jj_consume_token(SLASH);
            expr3 = UnaryExpression();
                                            expr2 = new E_Divide(expr2, expr3) ;
            break;
          default:
            jj_la1[113] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[114] = jj_gen;
          ;
        }
      if ( addition )
         expr1 = new E_Add(expr1, expr2) ;
      else
         expr1 = new E_Subtract(expr1, expr2) ;
        break;
      default:
        jj_la1[115] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return expr1 ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr MultiplicativeExpression() throws ParseException {
                                    Expr expr1, expr2 ;
    expr1 = UnaryExpression();
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
      case SLASH:
        ;
        break;
      default:
        jj_la1[116] = jj_gen;
        break label_30;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
        jj_consume_token(STAR);
        expr2 = UnaryExpression();
      expr1 = new E_Multiply(expr1, expr2) ;
        break;
      case SLASH:
        jj_consume_token(SLASH);
        expr2 = UnaryExpression();
      expr1 = new E_Divide(expr1, expr2) ;
        break;
      default:
        jj_la1[117] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
      {if (true) return expr1 ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr UnaryExpression() throws ParseException {
                           Expr expr ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BANG:
      jj_consume_token(BANG);
      expr = PrimaryExpression();
      {if (true) return new E_LogicalNot(expr) ;}
      break;
    case PLUS:
      jj_consume_token(PLUS);
      expr = PrimaryExpression();
                                        {if (true) return new E_UnaryPlus(expr) ;}
      break;
    case MINUS:
      jj_consume_token(MINUS);
      expr = PrimaryExpression();
                                         {if (true) return new E_UnaryMinus(expr) ;}
      break;
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case VAR1:
    case VAR2:
    case EXISTS:
    case NOTEXISTS:
    case COUNT:
    case MIN:
    case MAX:
    case SUM:
    case AVG:
    case SAMPLE:
    case GROUP_CONCAT:
    case BOUND:
    case COALESCE:
    case IF:
    case BNODE:
    case IRI:
    case URI:
    case STR:
    case STRLANG:
    case STRDT:
    case DTYPE:
    case LANG:
    case LANGMATCHES:
    case IS_URI:
    case IS_IRI:
    case IS_BLANK:
    case IS_LITERAL:
    case REGEX:
    case SAME_TERM:
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case LPAREN:
      expr = PrimaryExpression();
                                 {if (true) return expr ;}
      break;
    default:
      jj_la1[118] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Expr PrimaryExpression() throws ParseException {
                             Expr expr ; Node gn ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      expr = BrackettedExpression();
                                    {if (true) return expr ;}
      break;
    case EXISTS:
    case NOTEXISTS:
    case BOUND:
    case COALESCE:
    case IF:
    case BNODE:
    case IRI:
    case URI:
    case STR:
    case STRLANG:
    case STRDT:
    case DTYPE:
    case LANG:
    case LANGMATCHES:
    case IS_URI:
    case IS_IRI:
    case IS_BLANK:
    case IS_LITERAL:
    case REGEX:
    case SAME_TERM:
      expr = BuiltInCall();
                           {if (true) return expr ;}
      break;
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
      expr = IRIrefOrFunction();
                                {if (true) return expr ;}
      break;
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
      gn = RDFLiteral();
                        {if (true) return asExpr(gn) ;}
      break;
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
      gn = NumericLiteral();
                            {if (true) return asExpr(gn) ;}
      break;
    case TRUE:
    case FALSE:
      gn = BooleanLiteral();
                            {if (true) return asExpr(gn) ;}
      break;
    case VAR1:
    case VAR2:
      gn = Var();
                 {if (true) return asExpr(gn) ;}
      break;
    case COUNT:
    case MIN:
    case MAX:
    case SUM:
    case AVG:
    case SAMPLE:
    case GROUP_CONCAT:
      expr = Aggregate();
                         {if (true) return expr ;}
      break;
    default:
      jj_la1[119] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Expr BrackettedExpression() throws ParseException {
                                Expr expr ;
    jj_consume_token(LPAREN);
    expr = Expression();
    jj_consume_token(RPAREN);
                                            {if (true) return expr ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr BuiltInCall() throws ParseException {
                       Expr expr ; Expr expr1 = null ; Expr expr2 = null ;
                       Node gn ; Token t ; ExprList a ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STR:
      jj_consume_token(STR);
      jj_consume_token(LPAREN);
      expr = Expression();
      jj_consume_token(RPAREN);
      {if (true) return new E_Str(expr) ;}
      break;
    case LANG:
      jj_consume_token(LANG);
      jj_consume_token(LPAREN);
      expr = Expression();
      jj_consume_token(RPAREN);
      {if (true) return new E_Lang(expr) ;}
      break;
    case LANGMATCHES:
      jj_consume_token(LANGMATCHES);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(COMMA);
      expr2 = Expression();
      jj_consume_token(RPAREN);
      {if (true) return new E_LangMatches(expr1, expr2) ;}
      break;
    case DTYPE:
      jj_consume_token(DTYPE);
      jj_consume_token(LPAREN);
      expr = Expression();
      jj_consume_token(RPAREN);
      {if (true) return new E_Datatype(expr) ;}
      break;
    case BOUND:
      jj_consume_token(BOUND);
      jj_consume_token(LPAREN);
      gn = Var();
      jj_consume_token(RPAREN);
      {if (true) return new E_Bound(new ExprVar(gn)) ;}
      break;
    case IRI:
      jj_consume_token(IRI);
      jj_consume_token(LPAREN);
      expr = Expression();
      jj_consume_token(RPAREN);
      {if (true) return new E_IRI(expr) ;}
      break;
    case URI:
      jj_consume_token(URI);
      jj_consume_token(LPAREN);
      expr = Expression();
      jj_consume_token(RPAREN);
      {if (true) return new E_URI(expr) ;}
      break;
    case BNODE:
      jj_consume_token(BNODE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        expr1 = Expression();
        jj_consume_token(RPAREN);
        {if (true) return new E_BNode(expr1) ;}
        break;
      case NIL:
        jj_consume_token(NIL);
              {if (true) return new E_BNode() ;}
        break;
      default:
        jj_la1[120] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case COALESCE:
      jj_consume_token(COALESCE);
      a = ExpressionList();
      {if (true) return new E_Coalesce(a) ;}
      break;
    case IF:
      jj_consume_token(IF);
      jj_consume_token(LPAREN);
      expr = Expression();
      jj_consume_token(COMMA);
      expr1 = Expression();
      jj_consume_token(COMMA);
      expr2 = Expression();
      jj_consume_token(RPAREN);
      {if (true) return new E_Conditional(expr, expr1, expr2) ;}
      break;
    case STRLANG:
      jj_consume_token(STRLANG);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(COMMA);
      expr2 = Expression();
      jj_consume_token(RPAREN);
      {if (true) return new E_StrLang(expr1, expr2) ;}
      break;
    case STRDT:
      jj_consume_token(STRDT);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(COMMA);
      expr2 = Expression();
      jj_consume_token(RPAREN);
      {if (true) return new E_StrDatatype(expr1, expr2) ;}
      break;
    case SAME_TERM:
      jj_consume_token(SAME_TERM);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(COMMA);
      expr2 = Expression();
      jj_consume_token(RPAREN);
      {if (true) return new E_SameTerm(expr1, expr2) ;}
      break;
    case IS_IRI:
      t = jj_consume_token(IS_IRI);
      jj_consume_token(LPAREN);
      expr = Expression();
      jj_consume_token(RPAREN);
      {if (true) return new E_IsIRI(expr) ;}
      break;
    case IS_URI:
      t = jj_consume_token(IS_URI);
      jj_consume_token(LPAREN);
      expr = Expression();
      jj_consume_token(RPAREN);
      {if (true) return new E_IsURI(expr) ;}
      break;
    case IS_BLANK:
      jj_consume_token(IS_BLANK);
      jj_consume_token(LPAREN);
      expr = Expression();
      jj_consume_token(RPAREN);
      {if (true) return new E_IsBlank(expr) ;}
      break;
    case IS_LITERAL:
      jj_consume_token(IS_LITERAL);
      jj_consume_token(LPAREN);
      expr = Expression();
      jj_consume_token(RPAREN);
      {if (true) return new E_IsLiteral(expr) ;}
      break;
    case REGEX:
      // Regular expression matcher
          expr = RegexExpression();
                               {if (true) return expr ;}
      break;
    case EXISTS:
      expr = ExistsFunc();
                          {if (true) return expr ;}
      break;
    case NOTEXISTS:
      expr = NotExistsFunc();
                             {if (true) return expr ;}
      break;
    default:
      jj_la1[121] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Expr RegexExpression() throws ParseException {
  Expr expr ; Expr patExpr = null ; Expr flagsExpr = null ;
    jj_consume_token(REGEX);
    jj_consume_token(LPAREN);
    expr = Expression();
    jj_consume_token(COMMA);
    patExpr = Expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      flagsExpr = Expression();
      break;
    default:
      jj_la1[122] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        {if (true) return new E_Regex(expr, patExpr, flagsExpr) ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr ExistsFunc() throws ParseException {
                      Element el ;
    jj_consume_token(EXISTS);
    el = GroupGraphPattern();
     {if (true) return createExprExists(el) ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr NotExistsFunc() throws ParseException {
                         Element el ;
    jj_consume_token(NOTEXISTS);
    el = GroupGraphPattern();
     {if (true) return createExprNotExists(el) ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr Aggregate() throws ParseException {
                     AggregateFactory agg = null ; String sep = null ;
                     boolean distinct = false ;
                     Expr expr = null ; ExprList a = new ExprList() ;
                     Token t ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COUNT:
      t = jj_consume_token(COUNT);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DISTINCT:
        jj_consume_token(DISTINCT);
                   distinct = true ;
        break;
      default:
        jj_la1[123] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
        jj_consume_token(STAR);
        break;
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case VAR1:
      case VAR2:
      case EXISTS:
      case NOTEXISTS:
      case COUNT:
      case MIN:
      case MAX:
      case SUM:
      case AVG:
      case SAMPLE:
      case GROUP_CONCAT:
      case BOUND:
      case COALESCE:
      case IF:
      case BNODE:
      case IRI:
      case URI:
      case STR:
      case STRLANG:
      case STRDT:
      case DTYPE:
      case LANG:
      case LANGMATCHES:
      case IS_URI:
      case IS_IRI:
      case IS_BLANK:
      case IS_LITERAL:
      case REGEX:
      case SAME_TERM:
      case TRUE:
      case FALSE:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case INTEGER_POSITIVE:
      case DECIMAL_POSITIVE:
      case DOUBLE_POSITIVE:
      case INTEGER_NEGATIVE:
      case DECIMAL_NEGATIVE:
      case DOUBLE_NEGATIVE:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case LPAREN:
      case BANG:
      case PLUS:
      case MINUS:
        expr = Expression();
        break;
      default:
        jj_la1[124] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RPAREN);
      if ( ! distinct && expr == null ) { agg = AggCount.get() ; }
      if ( distinct && expr == null ) { agg = AggCountDistinct.get() ; }
      if ( ! distinct && expr != null ) { agg = new AggCountVar(expr) ; }
      if ( distinct && expr != null ) { agg = new AggCountVarDistinct(expr) ; }
      break;
    case SUM:
      t = jj_consume_token(SUM);
      expr = ExprAggArg();
                                    agg = new AggSum(expr) ;
      break;
    case MIN:
      t = jj_consume_token(MIN);
      expr = ExprAggArg();
                                    agg = new AggMin(expr) ;
      break;
    case MAX:
      t = jj_consume_token(MAX);
      expr = ExprAggArg();
                                    agg = new AggMax(expr) ;
      break;
    case AVG:
      t = jj_consume_token(AVG);
      expr = ExprAggArg();
                                    agg = new AggAvg(expr) ;
      break;
    case SAMPLE:
      t = jj_consume_token(SAMPLE);
      expr = ExprAggArg();
      break;
    case GROUP_CONCAT:
      t = jj_consume_token(GROUP_CONCAT);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DISTINCT:
        t = jj_consume_token(DISTINCT);
                      distinct = true ;
        break;
      default:
        jj_la1[125] = jj_gen;
        ;
      }
      expr = Expression();
                          a.add(expr) ;
      label_31:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[126] = jj_gen;
          break label_31;
        }
        jj_consume_token(COMMA);
        expr = Expression();
                                   a.add(expr) ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
        jj_consume_token(SEPARATOR);
        jj_consume_token(EQ);
        sep = String();
        break;
      default:
        jj_la1[127] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[128] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     if ( ! allowAggregatesInExpressions )
            throwParseException("Aggregate expression not legal at this point",
                                 t.beginLine, t.beginColumn) ;
     if ( agg != null )
        expr = getQuery().allocAggregate(agg) ;
     {if (true) return expr ;}
    throw new Error("Missing return statement in function");
  }

// See also FunctionCall.
// The case of "q:name()" or "q:agg()" or just "q:name"
// by expanding out FunctionCall()
  final public Expr IRIrefOrFunction() throws ParseException {
                            String iri ; ExprList a = null ;
                            ExprList params = null ;
                            boolean distinct = false ;
    iri = IRIref();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
    case NIL:
      a = ArgList();
      break;
    default:
      jj_la1[129] = jj_gen;
      ;
    }
    if ( a == null )
       {if (true) return asExpr(createNode(iri)) ;}
    {if (true) return new E_Function(iri, a) ;}
    throw new Error("Missing return statement in function");
  }

  final public Node RDFLiteral() throws ParseException {
                      Token t ; String lex = null ;
    lex = String();
    String lang = null ; String uri = null ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LANGTAG:
    case DATATYPE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LANGTAG:
        t = jj_consume_token(LANGTAG);
                      lang = stripChars(t.image, 1) ;
        break;
      case DATATYPE:
        jj_consume_token(DATATYPE);
        uri = IRIref();
        break;
      default:
        jj_la1[130] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[131] = jj_gen;
      ;
    }
      {if (true) return createLiteral(lex, lang, uri) ;}
    throw new Error("Missing return statement in function");
  }

  final public Node NumericLiteral() throws ParseException {
                          Node n ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
      n = NumericLiteralUnsigned();
      break;
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
      n = NumericLiteralPositive();
      break;
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
      n = NumericLiteralNegative();
      break;
    default:
      jj_la1[132] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return n ;}
    throw new Error("Missing return statement in function");
  }

  final public Node NumericLiteralUnsigned() throws ParseException {
                                  Token t ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER:
      t = jj_consume_token(INTEGER);
                  {if (true) return createLiteralInteger(t.image) ;}
      break;
    case DECIMAL:
      t = jj_consume_token(DECIMAL);
                  {if (true) return createLiteralDecimal(t.image) ;}
      break;
    case DOUBLE:
      t = jj_consume_token(DOUBLE);
                 {if (true) return createLiteralDouble(t.image) ;}
      break;
    default:
      jj_la1[133] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node NumericLiteralPositive() throws ParseException {
                                  Token t ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_POSITIVE:
      t = jj_consume_token(INTEGER_POSITIVE);
                           {if (true) return createLiteralInteger(t.image) ;}
      break;
    case DECIMAL_POSITIVE:
      t = jj_consume_token(DECIMAL_POSITIVE);
                           {if (true) return createLiteralDecimal(t.image) ;}
      break;
    case DOUBLE_POSITIVE:
      t = jj_consume_token(DOUBLE_POSITIVE);
                          {if (true) return createLiteralDouble(t.image) ;}
      break;
    default:
      jj_la1[134] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node NumericLiteralNegative() throws ParseException {
                                  Token t ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_NEGATIVE:
      t = jj_consume_token(INTEGER_NEGATIVE);
                           {if (true) return createLiteralInteger(t.image) ;}
      break;
    case DECIMAL_NEGATIVE:
      t = jj_consume_token(DECIMAL_NEGATIVE);
                           {if (true) return createLiteralDecimal(t.image) ;}
      break;
    case DOUBLE_NEGATIVE:
      t = jj_consume_token(DOUBLE_NEGATIVE);
                          {if (true) return createLiteralDouble(t.image) ;}
      break;
    default:
      jj_la1[135] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node BooleanLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      jj_consume_token(TRUE);
           {if (true) return XSD_TRUE ;}
      break;
    case FALSE:
      jj_consume_token(FALSE);
            {if (true) return XSD_FALSE ;}
      break;
    default:
      jj_la1[136] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String String() throws ParseException {
                    Token t ; String lex ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL1:
      t = jj_consume_token(STRING_LITERAL1);
                            lex = stripQuotes(t.image) ;
      break;
    case STRING_LITERAL2:
      t = jj_consume_token(STRING_LITERAL2);
                            lex = stripQuotes(t.image) ;
      break;
    case STRING_LITERAL_LONG1:
      t = jj_consume_token(STRING_LITERAL_LONG1);
                                 lex = stripQuotes3(t.image) ;
      break;
    case STRING_LITERAL_LONG2:
      t = jj_consume_token(STRING_LITERAL_LONG2);
                                 lex = stripQuotes3(t.image) ;
      break;
    default:
      jj_la1[137] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      lex = unescapeStr(lex, t.beginLine, t.beginColumn) ;
      {if (true) return lex ;}
    throw new Error("Missing return statement in function");
  }

  final public String IRIref() throws ParseException {
                    String iri ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IRIref:
      iri = IRI_REF();
                    {if (true) return iri ;}
      break;
    case PNAME_NS:
    case PNAME_LN:
      iri = PrefixedName();
                         {if (true) return iri ;}
      break;
    default:
      jj_la1[138] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String PrefixedName() throws ParseException {
                          Token t ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PNAME_LN:
      t = jj_consume_token(PNAME_LN);
      {if (true) return resolvePName(t.image, t.beginLine, t.beginColumn) ;}
      break;
    case PNAME_NS:
      t = jj_consume_token(PNAME_NS);
      {if (true) return resolvePName(t.image, t.beginLine, t.beginColumn) ;}
      break;
    default:
      jj_la1[139] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node BlankNode() throws ParseException {
                     Token t = null ;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BLANK_NODE_LABEL:
      t = jj_consume_token(BLANK_NODE_LABEL);
      {if (true) return createBNode(t.image, t.beginLine, t.beginColumn) ;}
      break;
    case ANON:
      jj_consume_token(ANON);
           {if (true) return createBNode() ;}
      break;
    default:
      jj_la1[140] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String IRI_REF() throws ParseException {
                     Token t ;
    t = jj_consume_token(IRIref);
    {if (true) return resolveQuotedIRI(t.image, t.beginLine, t.beginColumn) ;}
    throw new Error("Missing return statement in function");
  }

  /** Generated Token Manager. */
  public SPARQLParser11TokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[141];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x3900000,0x3900000,0x40000,0x80000,0x0,0x600000,0x600000,0x3000,0x3000,0x3000,0x0,0x3700,0x3700,0x0,0x0,0x0,0x700,0x0,0x0,0x0,0x10000000,0xc000000,0x3700,0x0,0x3700,0x700,0x3700,0x0,0x3700,0x3700,0x8000000,0x4000000,0xc000000,0x3000,0x0,0x80000700,0x40000000,0x80000700,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x700,0x0,0x0,0x0,0x700,0x3f00,0x0,0x0,0x3f00,0x3f00,0x0,0x100000,0x3f00,0x0,0x0,0x3f00,0x3f00,0x0,0x0,0x700,0x200000,0x0,0x0,0x200000,0x0,0x0,0x3f00,0x3f00,0x0,0x3f00,0x0,0x23700,0x23700,0x0,0x23700,0x3f00,0x23700,0x0,0x23700,0x23700,0x23700,0x0,0x0,0x0,0x0,0x20700,0x0,0x0,0x0,0x20700,0x0,0x20700,0x20700,0x20700,0x0,0x3f00,0x3f00,0x3f00,0x3700,0x3000,0xf00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3700,0x3700,0x0,0x0,0x0,0x200000,0x3700,0x200000,0x0,0x0,0x0,0x0,0x4000,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x700,0x600,0x800,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x8,0x10,0x8,0x4,0x10,0x8000,0x10000,0x0,0x0,0x30001400,0x4000,0x30001400,0x30001400,0x30001403,0x3,0x30001400,0x30001403,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x80023c0,0x0,0x0,0x0,0x0,0x80023c0,0x30001400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0xc0000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x36f81400,0x36f81400,0x0,0x30001400,0x0,0x0,0x36f81400,0x0,0x0,0x0,0x6f80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x25d80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1ffef,0x0,0x1ffef,0x1ffef,0x1ffef,0x0,0x1ffef,0x1ffef,0x0,0x0,0x0,0x0,0x0,0x80060000,0x0,0x80060000,0x25d80000,0x25d80000,0x0,0x20000000,0x180000,0x200000,0x80000,0x200000,0x0,0x8000000,0x2000000,0x2000000,0x10000000,0x80060000,0x0,0x0,0x80060000,0x80060000,0x0,0x0,0x80060000,0x0,0x0,0x80060000,0x80060000,0x0,0x0,0x1ffef,0x0,0x0,0x0,0x0,0x0,0x0,0x80060000,0x80060000,0x0,0x80060000,0x0,0x0,0x0,0x0,0x0,0x80060000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80060000,0x80060000,0x80060000,0x0,0x0,0x80060000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8007ffef,0x8007ffef,0x0,0x1ffef,0x0,0x0,0x8007ffef,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x0,0x60000,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x10000,0x10000,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x10000,0x10000,0x10000,0x0,0x10000,0x10000,0x0,0x0,0x0,0x0,0x10000,0xf0ff,0x0,0xf0ff,0x0,0x0,0x1000000,0x0,0x0,0x80000,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0xa5f0ff,0x0,0x4000000,0xa5f0ff,0xa5f0ff,0x4000000,0x0,0xa5f0ff,0x80000,0x4000000,0xa5f0ff,0xa5f0ff,0x4000000,0x80000,0x10000,0x0,0x2000000,0x50000,0x0,0x2000000,0x50000,0xa5f0ff,0xa5f0ff,0x4000000,0xa5f0ff,0x1000000,0x0,0x0,0x2000000,0x0,0xa5f0ff,0x10000,0x1000000,0x10000,0x10000,0x0,0x0,0x0,0x0,0x80000,0x10000,0x100000,0x2100000,0x80000,0x10000,0x0,0x0,0x10000,0x0,0x210000,0xa5f0ff,0xa5f0ff,0x84f0ff,0x0,0x0,0x84f0ff,0x0,0x0,0xf8000000,0xf8000000,0xfc,0xfc,0x0,0x0,0xfc,0x0,0x0,0x1f0ff,0x1f0ff,0x50000,0x0,0x2000000,0x0,0x1f0ff,0x0,0x2000000,0x1000000,0x0,0x50000,0x0,0x0,0xff,0x3,0x1c,0xe0,0x0,0xf000,0x0,0x0,0x800000,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2002,0x0,0x2002,0x2002,0x0,0x1000,0x2200,0x2200,0x10140,0x2002,0x0,0x0,0x10140,0x2,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x20,0x1,0x1,0xc0,0x0,0x300,0x300,0xc0,0x300,0x300,0xc2,0x0,0x0,0x0,0x0,0x0,0x1c2,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }

  /** Constructor with InputStream. */
  public SPARQLParser11(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public SPARQLParser11(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new SPARQLParser11TokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 141; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 141; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public SPARQLParser11(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new SPARQLParser11TokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 141; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 141; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public SPARQLParser11(SPARQLParser11TokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 141; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(SPARQLParser11TokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 141; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[152];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 141; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 152; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
