/*
 * (c) Copyright 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009 Hewlett-Packard Development Company, LP
 * [See end of file]
 */

/* Generated By:JJTree: Do not edit this line. Q_UnaryNot.java */

package com.hp.hpl.jena.sparql.lang.rdql;

import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.query.*;
import com.hp.hpl.jena.sparql.util.IndentedWriter;

public class Q_UnaryNot extends ExprNodeRDQL implements ExprRDQL, ExprBoolean
{
    private String printName = "not";
    private String opSymbol  = "!";
    ExprRDQL           expr;

    Q_UnaryNot(int id)
    {
        super(id);
    }

    Q_UnaryNot(RDQLParser p, int id)
    {
        super(p, id);
    }

    @Override
    public void jjtClose()
    {
        int n = jjtGetNumChildren();
        if (n != 1) throw new QueryException("Q_UnaryNot: Wrong number of children: " + n);
        expr = (ExprRDQL) jjtGetChild(0);
    }

    public RDQL_NodeValue evalRDQL(Query q, IndexValues env)
    {
        RDQL_NodeValue v = expr.evalRDQL(q, env);

        if (!v.isBoolean()) throw new RDQLEvalTypeException("Q_UnaryNot: Wanted a number: got " + expr);

        NodeValueSettable result;

        result = new WorkingVar();
        result.setBoolean(!v.getBoolean());
        return result;
    }

    // -----------
    // graph.query.Expression

    @Override
    public boolean isApply()         { return true ; }
    @Override
    public String getFun()           { return super.constructURI(this.getClass().getName()) ; }
    @Override
    public int argCount()            { return 1; }
    @Override
    public Expression getArg(int i)  
    {
        if ( i == 0 && expr instanceof Expression )
            return (Expression)expr ;
        return null;
    }

    public String asInfixString()
    {
        return RDQLQueryPrintUtils.asInfixString1(expr, printName, opSymbol);
    }

    public String asPrefixString()
    {
        return RDQLQueryPrintUtils.asPrefixString(expr, null, printName, opSymbol);
    }

    @Override
    public void format(IndentedWriter w)
    {
        RDQLQueryPrintUtils.format(w, expr, null, printName, opSymbol) ;
    }

    @Override
    public String toString()
    {
        return asInfixString();
    }

}

/*
 * (c) Copyright 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009 Hewlett-Packard Development Company, LP
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met: 1.
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer. 2. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution. 3. The name of the author may not
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
