/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.modify.UpdateVisitor;
import com.hp.hpl.jena.sparql.modify.op.GraphUpdateN;
import com.hp.hpl.jena.sparql.modify.op.UpdateClear;
import com.hp.hpl.jena.sparql.modify.op.UpdateCreate;
import com.hp.hpl.jena.sparql.modify.op.UpdateDelete;
import com.hp.hpl.jena.sparql.modify.op.UpdateDeleteData;
import com.hp.hpl.jena.sparql.modify.op.UpdateDrop;
import com.hp.hpl.jena.sparql.modify.op.UpdateExt;
import com.hp.hpl.jena.sparql.modify.op.UpdateInsert;
import com.hp.hpl.jena.sparql.modify.op.UpdateInsertData;
import com.hp.hpl.jena.sparql.modify.op.UpdateLoad;
import com.hp.hpl.jena.sparql.modify.op.UpdateModify;
import com.hp.hpl.jena.sparql.modify.op.UpdateModifyBase;
import com.hp.hpl.jena.sparql.serializer.FmtTemplate;
import com.hp.hpl.jena.sparql.serializer.FormatterElement;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class UpdateSerializer
implements UpdateVisitor {
    IndentedWriter out;
    SerializationContext sCxt;

    public UpdateSerializer(IndentedWriter out, SerializationContext sCxt) {
        this.out = out;
        this.sCxt = sCxt;
    }

    private void visitModifyHeader(String name, String word, GraphUpdateN modify) {
        this.out.print(name);
        for (Node iri : modify.getGraphNames()) {
            if (word != null) {
                this.out.print(" ");
                this.out.print(word);
            }
            this.out.print(" ");
            this.out.print(FmtUtils.stringForNode(iri, this.sCxt));
        }
        this.out.println();
    }

    private void visitModifyTrailer(UpdateModifyBase modify) {
        if (modify.getElement() != null) {
            this.out.println("WHERE");
            this.out.incIndent();
            FormatterElement.format(this.out, this.sCxt, modify.getElement());
            this.out.decIndent();
            this.out.println();
        }
    }

    public void visit(UpdateModify modify) {
        this.visitModifyHeader("MODIFY", "GRAPH", modify);
        this.out.println("DELETE");
        this.printTemplate(modify.getDeleteTemplate());
        this.out.println("INSERT");
        this.printTemplate(modify.getInsertTemplate());
        this.visitModifyTrailer(modify);
    }

    public void visit(UpdateDelete delete) {
        this.visitModifyHeader("DELETE", "FROM", delete);
        this.printTemplate(delete.getDeleteTemplate());
        this.visitModifyTrailer(delete);
    }

    public void visit(UpdateInsert insert) {
        this.visitModifyHeader("INSERT", "INTO", insert);
        this.printTemplate(insert.getInsertTemplate());
        this.visitModifyTrailer(insert);
    }

    public void visit(UpdateInsertData add) {
        this.visitModifyHeader("INSERT DATA", "INTO", add);
        this.printGraph(add.getData());
    }

    public void visit(UpdateDeleteData remove) {
        this.visitModifyHeader("DELETE DATA", "FROM", remove);
        this.printGraph(remove.getData());
    }

    public void visit(UpdateClear clear) {
        this.out.print("CLEAR");
        if (clear.hasGraphName()) {
            this.out.print(" ");
            FmtUtils.stringForNode(clear.getGraphName(), this.sCxt);
        }
        this.out.println();
    }

    public void visit(UpdateLoad load) {
        this.out.print("LOAD");
        for (String iri : load.getLoadIRIs()) {
            this.out.print(" ");
            FmtUtils.stringForURI(iri, this.sCxt);
        }
        if (load.hasGraphName()) {
            this.out.print(" ");
            this.out.print("INTO");
            this.out.print(" ");
            String s = FmtUtils.stringForNode(load.getGraphName(), this.sCxt);
            this.out.print(s);
        }
        this.out.println();
    }

    public void visit(UpdateDrop drop) {
        this.out.print("DROP");
        if (drop.isSilent()) {
            this.out.print(" ");
            this.out.print("SILENT");
        }
        this.out.print(" ");
        this.out.print("GRAPH");
        this.out.print(" ");
        this.out.print(FmtUtils.stringForNode(drop.getIRI(), this.sCxt));
        this.out.println();
    }

    public void visit(UpdateCreate create) {
        this.out.print("CREATE");
        if (create.isSilent()) {
            this.out.print(" ");
            this.out.print("SILENT");
        }
        this.out.print(" ");
        this.out.print("GRAPH");
        this.out.print(" ");
        this.out.print(FmtUtils.stringForNode(create.getIRI(), this.sCxt));
        this.out.println();
    }

    public void visit(UpdateExt updateExt) {
        updateExt.print(this.out);
    }

    private void printTemplate(Template template) {
        this.out.incIndent();
        FmtTemplate.format(this.out, this.sCxt, template);
        this.out.decIndent();
    }

    private void printGraph(Graph data) {
        this.out.println("{");
        this.out.incIndent();
        ExtendedIterator iter = data.find(Node.ANY, Node.ANY, Node.ANY);
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            String s = FmtUtils.stringForTriple(t, this.sCxt.getPrefixMapping());
            this.out.println(s);
        }
        this.out.decIndent();
        this.out.println("}");
    }
}

