/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.sparql.function.CastXSD;
import com.hp.hpl.jena.sparql.function.FunctionRegistry;
import com.hp.hpl.jena.sparql.function.library.BEV;
import com.hp.hpl.jena.sparql.function.library.abs;
import com.hp.hpl.jena.sparql.function.library.ceiling;
import com.hp.hpl.jena.sparql.function.library.floor;
import com.hp.hpl.jena.sparql.function.library.matches;
import com.hp.hpl.jena.sparql.function.library.not;
import com.hp.hpl.jena.sparql.function.library.strConcat;
import com.hp.hpl.jena.sparql.function.library.strContains;
import com.hp.hpl.jena.sparql.function.library.strEndsWith;
import com.hp.hpl.jena.sparql.function.library.strLength;
import com.hp.hpl.jena.sparql.function.library.strLowerCase;
import com.hp.hpl.jena.sparql.function.library.strStartsWith;
import com.hp.hpl.jena.sparql.function.library.strSubstring;
import com.hp.hpl.jena.sparql.function.library.strUpperCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardFunctions {
    public static void loadStdDefs(FunctionRegistry registry) {
        String xfn = "http://www.w3.org/2005/xpath-functions#";
        StandardFunctions.addCast(registry, XSDDatatype.XSDdecimal);
        StandardFunctions.addCast(registry, XSDDatatype.XSDinteger);
        StandardFunctions.addCast(registry, XSDDatatype.XSDlong);
        StandardFunctions.addCast(registry, XSDDatatype.XSDint);
        StandardFunctions.addCast(registry, XSDDatatype.XSDshort);
        StandardFunctions.addCast(registry, XSDDatatype.XSDbyte);
        StandardFunctions.addCast(registry, XSDDatatype.XSDnonPositiveInteger);
        StandardFunctions.addCast(registry, XSDDatatype.XSDnegativeInteger);
        StandardFunctions.addCast(registry, XSDDatatype.XSDnonNegativeInteger);
        StandardFunctions.addCast(registry, XSDDatatype.XSDpositiveInteger);
        StandardFunctions.addCast(registry, XSDDatatype.XSDunsignedLong);
        StandardFunctions.addCast(registry, XSDDatatype.XSDunsignedInt);
        StandardFunctions.addCast(registry, XSDDatatype.XSDunsignedShort);
        StandardFunctions.addCast(registry, XSDDatatype.XSDdouble);
        StandardFunctions.addCast(registry, XSDDatatype.XSDfloat);
        StandardFunctions.addCast(registry, XSDDatatype.XSDdateTime);
        StandardFunctions.addCast(registry, XSDDatatype.XSDdate);
        StandardFunctions.addCast(registry, XSDDatatype.XSDboolean);
        StandardFunctions.addCast(registry, XSDDatatype.XSDstring);
        StandardFunctions.addCast(registry, XSDDatatype.XSDanyURI);
        StandardFunctions.add(registry, xfn + "boolean", BEV.class);
        StandardFunctions.add(registry, xfn + "not", not.class);
        StandardFunctions.add(registry, xfn + "matches", matches.class);
        StandardFunctions.add(registry, xfn + "string-length", strLength.class);
        StandardFunctions.add(registry, xfn + "string-join", strConcat.class);
        StandardFunctions.add(registry, xfn + "concat", strConcat.class);
        StandardFunctions.add(registry, xfn + "substring", strSubstring.class);
        StandardFunctions.add(registry, xfn + "starts-with", strStartsWith.class);
        StandardFunctions.add(registry, xfn + "lower-case", strLowerCase.class);
        StandardFunctions.add(registry, xfn + "upper-case", strUpperCase.class);
        StandardFunctions.add(registry, xfn + "contains", strContains.class);
        StandardFunctions.add(registry, xfn + "ends-with", strEndsWith.class);
        StandardFunctions.add(registry, xfn + "abs", abs.class);
        StandardFunctions.add(registry, xfn + "ceiling", ceiling.class);
        StandardFunctions.add(registry, xfn + "floor", floor.class);
    }

    private static void addCast(FunctionRegistry registry, XSDDatatype dt) {
        registry.put(dt.getURI(), new CastXSD(dt));
    }

    private static void add(FunctionRegistry registry, String uri, Class<?> funcClass) {
        registry.put(uri, funcClass);
    }
}

