/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.ref;

import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.TableFactory;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpConditional;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpDiff;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroupAgg;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLabel;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpList;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpPath;
import com.hp.hpl.jena.sparql.algebra.op.OpProcedure;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpPropFunc;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpTriple;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.http.Service;
import com.hp.hpl.jena.sparql.engine.ref.Eval;
import com.hp.hpl.jena.sparql.engine.ref.Evaluator;
import com.hp.hpl.jena.sparql.util.ALog;
import java.util.Iterator;
import java.util.Stack;

public class EvaluatorDispatch
implements OpVisitor {
    private Stack<Table> stack = new Stack();
    protected Evaluator evaluator;

    public EvaluatorDispatch(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    protected Table eval(Op op) {
        op.visit(this);
        return this.pop();
    }

    Table getResult() {
        if (this.stack.size() != 1) {
            ALog.warn(this, "Warning: getResult: stack size = " + this.stack.size());
        }
        Table table = this.pop();
        return table;
    }

    public void visit(OpBGP opBGP) {
        Table table = this.evaluator.basicPattern(opBGP.getPattern());
        this.push(table);
    }

    public void visit(OpQuadPattern quadPattern) {
        this.push(Eval.evalQuadPattern(quadPattern, this.evaluator));
    }

    public void visit(OpTriple opTriple) {
        this.visit(opTriple.asBGP());
    }

    public void visit(OpPath opPath) {
        Table table = this.evaluator.pathPattern(opPath.getTriplePath());
        this.push(table);
    }

    public void visit(OpProcedure opProc) {
        Table table = this.eval(opProc.getSubOp());
        table = this.evaluator.procedure(table, opProc.getProcId(), opProc.getArgs());
        this.push(table);
    }

    public void visit(OpPropFunc opPropFunc) {
        Table table = this.eval(opPropFunc.getSubOp());
        table = this.evaluator.propertyFunction(table, opPropFunc.getProperty(), opPropFunc.getSubjectArgs(), opPropFunc.getObjectArgs());
        this.push(table);
    }

    public void visit(OpJoin opJoin) {
        Table left = this.eval(opJoin.getLeft());
        Table right = this.eval(opJoin.getRight());
        Table table = this.evaluator.join(left, right);
        this.push(table);
    }

    public void visit(OpSequence opSequence) {
        Table table = TableFactory.createUnit();
        Iterator<Op> iter = opSequence.iterator();
        while (iter.hasNext()) {
            Op op = iter.next();
            Table eltTable = this.eval(op);
            table = this.evaluator.join(table, eltTable);
        }
        this.push(table);
    }

    public void visit(OpLeftJoin opLeftJoin) {
        Table left = this.eval(opLeftJoin.getLeft());
        Table right = this.eval(opLeftJoin.getRight());
        Table table = this.evaluator.leftJoin(left, right, opLeftJoin.getExprs());
        this.push(table);
    }

    public void visit(OpDiff opDiff) {
        Table left = this.eval(opDiff.getLeft());
        Table right = this.eval(opDiff.getRight());
        Table table = this.evaluator.diff(left, right);
        this.push(table);
    }

    public void visit(OpUnion opUnion) {
        Table left = this.eval(opUnion.getLeft());
        Table right = this.eval(opUnion.getRight());
        Table table = this.evaluator.union(left, right);
        this.push(table);
    }

    public void visit(OpConditional opCond) {
        Table left = this.eval(opCond.getLeft());
        Table right = this.eval(opCond.getRight());
        Table table = this.evaluator.condition(left, right);
        this.push(table);
    }

    public void visit(OpFilter opFilter) {
        Table table = this.eval(opFilter.getSubOp());
        table = this.evaluator.filter(opFilter.getExprs(), table);
        this.push(table);
    }

    public void visit(OpGraph opGraph) {
        this.push(Eval.evalGraph(opGraph, this.evaluator));
    }

    public void visit(OpService opService) {
        QueryIterator qIter = Service.exec(opService);
        Table table = TableFactory.create(qIter);
        this.push(table);
    }

    public void visit(OpDatasetNames dsNames) {
        this.push(Eval.evalDS(dsNames, this.evaluator));
    }

    public void visit(OpTable opTable) {
        this.push(opTable.getTable());
    }

    public void visit(OpExt opExt) {
        throw new QueryExecException("Encountered OpExt during execution of reference engine");
    }

    public void visit(OpNull opNull) {
        this.push(TableFactory.createEmpty());
    }

    public void visit(OpLabel opLabel) {
        if (opLabel.hasSubOp()) {
            this.push(this.eval(opLabel.getSubOp()));
        } else {
            this.push(TableFactory.createUnit());
        }
    }

    public void visit(OpList opList) {
        Table table = this.eval(opList.getSubOp());
        table = this.evaluator.list(table);
        this.push(table);
    }

    public void visit(OpOrder opOrder) {
        Table table = this.eval(opOrder.getSubOp());
        table = this.evaluator.order(table, opOrder.getConditions());
        this.push(table);
    }

    public void visit(OpProject opProject) {
        Table table = this.eval(opProject.getSubOp());
        table = this.evaluator.project(table, opProject.getVars());
        this.push(table);
    }

    public void visit(OpDistinct opDistinct) {
        Table table = this.eval(opDistinct.getSubOp());
        table = this.evaluator.distinct(table);
        this.push(table);
    }

    public void visit(OpReduced opReduced) {
        Table table = this.eval(opReduced.getSubOp());
        table = this.evaluator.reduced(table);
        this.push(table);
    }

    public void visit(OpSlice opSlice) {
        Table table = this.eval(opSlice.getSubOp());
        table = this.evaluator.slice(table, opSlice.getStart(), opSlice.getLength());
        this.push(table);
    }

    public void visit(OpAssign opAssign) {
        Table table = this.eval(opAssign.getSubOp());
        table = this.evaluator.assign(table, opAssign.getVarExprList());
        this.push(table);
    }

    public void visit(OpGroupAgg opGroupAgg) {
        Table table = this.eval(opGroupAgg.getSubOp());
        table = this.evaluator.groupBy(table, opGroupAgg.getGroupVars(), opGroupAgg.getAggregators());
        this.push(table);
    }

    protected void push(Table table) {
        this.stack.push(table);
    }

    protected Table pop() {
        if (this.stack.size() == 0) {
            ALog.warn(this, "Warning: pop: empty stack");
        }
        return this.stack.pop();
    }
}

