/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphStatisticsHandler;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.mem.faster.GraphMemFaster;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.Explain;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterBlockTriples;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterBlockTriplesQH;
import com.hp.hpl.jena.sparql.engine.main.StageGenerator;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.PatternElements;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.PatternTriple;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderFixed;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderLib;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderTransformationBase;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.sparql.util.Utils;

public class StageGeneratorGeneric
implements StageGenerator {
    public static final Symbol altMatcher = ARQConstants.allocSymbol("altmatcher");
    private static StageGenerator executeQueryHandler = new StageGenerator(){

        public QueryIterator execute(BasicPattern pattern, QueryIterator input, ExecutionContext execCxt) {
            return QueryIterBlockTriplesQH.create(input, pattern, execCxt);
        }
    };
    private static StageGenerator executeInline = new StageGenerator(){

        public QueryIterator execute(BasicPattern pattern, QueryIterator input, ExecutionContext execCxt) {
            return QueryIterBlockTriples.create(input, pattern, execCxt);
        }
    };

    public QueryIterator execute(BasicPattern pattern, QueryIterator input, ExecutionContext execCxt) {
        StageGenerator executor;
        ReorderTransformation reorder;
        Graph graph;
        if (input == null) {
            ALog.fatal(this, "Null input to " + Utils.classShortName(this.getClass()));
        }
        if ((graph = execCxt.getActiveGraph()) instanceof GraphMemFaster) {
            reorder = StageGeneratorGeneric.reorderBasicStats(graph);
            executor = executeInline;
        } else if (graph instanceof GraphRDB) {
            reorder = null;
            executor = executeQueryHandler;
        } else if (graph instanceof GraphMem) {
            reorder = StageGeneratorGeneric.reorderBasicStats(graph);
            executor = executeInline;
        } else {
            reorder = null;
            executor = executeInline;
        }
        return this.execute(pattern, reorder, executor, input, execCxt);
    }

    protected QueryIterator execute(BasicPattern pattern, ReorderTransformation reorder, StageGenerator execution, QueryIterator input, ExecutionContext execCxt) {
        boolean loggingExec;
        boolean bl = loggingExec = Explain.explaining(execCxt.getContext()) && Explain.logExec.isDebugEnabled();
        if (loggingExec) {
            Explain.logExec.debug(">>" + pattern);
        }
        if (reorder != null) {
            pattern = reorder.reorder(pattern);
            if (loggingExec) {
                Explain.logExec.debug("->" + pattern);
            }
        }
        return execution.execute(pattern, input, execCxt);
    }

    private static ReorderTransformation reorderFixed() {
        return ReorderLib.fixed();
    }

    private static ReorderTransformation reorderBasicStats(Graph graph) {
        GraphStatisticsHandler stats = graph.getStatisticsHandler();
        if (stats == null) {
            return StageGeneratorGeneric.reorderFixed();
        }
        return new ReorderStatsHandler(graph, graph.getStatisticsHandler());
    }

    private static QueryIterator baseExecute(BasicPattern pattern, QueryIterator input, ExecutionContext execCxt) {
        if (execCxt.getContext().isTrueOrUndef(altMatcher)) {
            return StageGeneratorGeneric.executeInline(pattern, input, execCxt);
        }
        return StageGeneratorGeneric.executeQueryHandler(pattern, input, execCxt);
    }

    private static QueryIterator executeInline(BasicPattern pattern, QueryIterator input, ExecutionContext execCxt) {
        return QueryIterBlockTriples.create(input, pattern, execCxt);
    }

    private static QueryIterator executeQueryHandler(BasicPattern pattern, QueryIterator input, ExecutionContext execCxt) {
        return QueryIterBlockTriplesQH.create(input, pattern, execCxt);
    }

    static /* synthetic */ ReorderTransformation access$000() {
        return StageGeneratorGeneric.reorderFixed();
    }

    private static class ReorderStatsHandler
    extends ReorderTransformationBase {
        static ReorderFixed fixed = (ReorderFixed)StageGeneratorGeneric.access$000();
        final long TERM_S;
        final long TERM_TYPE;
        final long TERM_P;
        final long TERM_O;
        final long N;
        private GraphStatisticsHandler stats;

        ReorderStatsHandler(Graph graph, GraphStatisticsHandler stats) {
            this.stats = stats;
            this.N = graph.size();
            this.TERM_S = 10L;
            this.TERM_P = this.N / 10L;
            this.TERM_O = 20L;
            this.TERM_TYPE = this.N / 10L;
        }

        protected double weight(PatternTriple pt) {
            double x = fixed.weight(pt);
            if (!(x < (double)ReorderFixed.MultiTermMax)) {
                x = this.weight1(pt);
            }
            return x;
        }

        private double weight1(PatternTriple pt) {
            long S = -1L;
            long P = -1L;
            long O = -1L;
            if (pt.subject.isNode()) {
                S = this.stats.getStatistic(pt.subject.getNode(), Node.ANY, Node.ANY);
            } else if (PatternElements.TERM.equals(pt.subject)) {
                S = this.TERM_S;
            }
            if (pt.predicate.isNode()) {
                P = this.stats.getStatistic(Node.ANY, pt.predicate.getNode(), Node.ANY);
            } else if (PatternElements.TERM.equals(pt.predicate)) {
                P = this.TERM_P;
            }
            if (pt.object.isNode()) {
                O = this.stats.getStatistic(Node.ANY, Node.ANY, pt.object.getNode());
            } else if (PatternElements.TERM.equals(pt.object)) {
                O = this.TERM_O;
            }
            if (S == 0L || P == 0L || O == 0L) {
                return 0.0;
            }
            double x = -1.0;
            if (S > 0L) {
                x = S;
            }
            if (P > 0L && (double)P < x) {
                x = P;
            }
            if (O > 0L && (double)O < x) {
                x = O;
            }
            return x;
        }
    }
}

