/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.larq;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryBuildException;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.query.larq.HitLARQ;
import com.hp.hpl.jena.query.larq.IndexLARQ;
import com.hp.hpl.jena.query.larq.ScoreTest;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIter;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterNullIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSingleton;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSlice;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArgType;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionEval;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.IterLib;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import com.hp.hpl.jena.sparql.util.iterator.IteratorTruncate;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.Map1Iterator;
import java.util.Iterator;

public abstract class LuceneSearch
extends PropertyFunctionEval {
    protected LuceneSearch() {
        super(PropFuncArgType.PF_ARG_EITHER, PropFuncArgType.PF_ARG_EITHER);
    }

    protected abstract IndexLARQ getIndex(ExecutionContext var1);

    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        super.build(argSubject, predicate, argObject, execCxt);
        if (this.getIndex(execCxt) == null) {
            throw new QueryBuildException("Index not found");
        }
        if (argSubject.isList() && argSubject.getArgListSize() != 2) {
            throw new QueryBuildException("Subject has " + argSubject.getArgList().size() + " elements, not 2: " + argSubject);
        }
        if (argObject.isList() && argObject.getArgListSize() != 2 && argObject.getArgListSize() != 3) {
            throw new QueryBuildException("Object has " + argObject.getArgList().size() + " elements, not 2 or 3: " + argObject);
        }
    }

    public QueryIterator execEvaluated(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        try {
            return this.execEvaluatedProtected(binding, argSubject, predicate, argObject, execCxt);
        }
        catch (RuntimeException ex) {
            ALog.fatal(this, "Exception from Lucene search", (Throwable)ex);
            throw ex;
        }
    }

    private QueryIterator execEvaluatedProtected(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        Var scoreVar;
        Node match = null;
        Node score = null;
        Node searchString = null;
        long limit = Long.MIN_VALUE;
        float scoreLimit = -1.0f;
        if (argSubject.isList()) {
            match = argSubject.getArg(0);
            score = argSubject.getArg(1);
            if (!score.isVariable()) {
                throw new QueryExecException("Hit score is not a variable: " + argSubject);
            }
        } else {
            match = argSubject.getArg();
        }
        if (argObject.isList()) {
            searchString = argObject.getArg(0);
            for (int i = 1; i < argObject.getArgListSize(); ++i) {
                Node n = argObject.getArg(i);
                int nInt = LuceneSearch.asInteger(n);
                if (LuceneSearch.isInteger(nInt)) {
                    if (limit > 0L) {
                        throw new ExprEvalException("2 potential limits to Lucene search: " + argObject);
                    }
                    limit = nInt;
                    if (limit >= 0L) continue;
                    limit = Long.MIN_VALUE;
                    continue;
                }
                float nFloat = LuceneSearch.asFloat(n);
                if (LuceneSearch.isFloat(nFloat)) {
                    if (scoreLimit > 0.0f) {
                        throw new ExprEvalException("2 potential score limits to Lucene search: " + argObject);
                    }
                    if (nFloat < 0.0f) {
                        throw new ExprEvalException("Negative score limit to Lucene search: " + argObject);
                    }
                    scoreLimit = nFloat;
                    continue;
                }
                throw new ExprEvalException("Bad argument to Lucene search: " + argObject);
            }
            if (scoreLimit < 0.0f) {
                scoreLimit = 0.0f;
            }
            if (!LuceneSearch.isValidSearchString(searchString)) {
                return new QueryIterNullIterator(execCxt);
            }
        } else {
            searchString = argObject.getArg();
            limit = Long.MIN_VALUE;
            scoreLimit = 0.0f;
        }
        if (!LuceneSearch.isValidSearchString(searchString)) {
            return IterLib.noResults(execCxt);
        }
        String qs = LuceneSearch.asString(searchString);
        if (qs == null) {
            ALog.warn(this, "Not a string (it was a moment ago!): " + searchString);
            return new QueryIterNullIterator(execCxt);
        }
        Var var = scoreVar = score == null ? null : Var.alloc(score);
        if (match.isVariable()) {
            return this.varSubject(binding, Var.alloc(match), scoreVar, qs, limit, scoreLimit, execCxt);
        }
        return this.boundSubject(binding, match, scoreVar, qs, limit, scoreLimit, execCxt);
    }

    private static boolean isValidSearchString(Node searchString) {
        if (!searchString.isLiteral()) {
            ALog.warn(LuceneSearch.class, "Not a string: " + searchString);
            return false;
        }
        if (searchString.getLiteralDatatypeURI() != null) {
            ALog.warn(LuceneSearch.class, "Not a plain string: " + searchString);
            return false;
        }
        if (searchString.getLiteralLanguage() != null && !searchString.getLiteralLanguage().equals("")) {
            ALog.warn(LuceneSearch.class, "Not a plain string (has lang tag): " + searchString);
            return false;
        }
        return true;
    }

    public QueryIterator varSubject(Binding binding, Var match, Var score, String searchString, long limit, float scoreLimit, ExecutionContext execCxt) {
        Iterator<HitLARQ> iter = this.getIndex(execCxt).search(searchString);
        if (scoreLimit > 0.0f) {
            iter = new IteratorTruncate<HitLARQ>(new ScoreTest(scoreLimit), iter);
        }
        HitConverter converter = new HitConverter(binding, match, score);
        Map1Iterator iter2 = new Map1Iterator((Map1)converter, iter);
        QueryIter qIter = new QueryIterPlainWrapper((Iterator<Binding>)iter2, execCxt);
        if (limit >= 0L) {
            qIter = new QueryIterSlice(qIter, 0L, limit, execCxt);
        }
        return qIter;
    }

    public QueryIterator boundSubject(Binding binding, Node match, Var score, String searchString, long limit, float scoreLimit, ExecutionContext execCxt) {
        HitLARQ hit = this.getIndex(execCxt).contains(match, searchString);
        if (hit == null) {
            return new QueryIterNullIterator(execCxt);
        }
        if (score == null) {
            return new QueryIterSingleton(binding, execCxt);
        }
        return IterLib.oneResult(binding, score, NodeFactory.floatToNode(hit.getScore()), execCxt);
    }

    private static String asString(Node node) {
        if (node.getLiteralDatatype() != null && !node.getLiteralDatatype().equals(XSDDatatype.XSDstring)) {
            return null;
        }
        return node.getLiteralLexicalForm();
    }

    private static float asFloat(Node n) {
        if (n == null) {
            return Float.MIN_VALUE;
        }
        NodeValue nv = NodeValue.makeNode(n);
        if (nv.isFloat()) {
            return nv.getFloat();
        }
        return Float.MIN_VALUE;
    }

    private static int asInteger(Node n) {
        if (n == null) {
            return Integer.MIN_VALUE;
        }
        return NodeFactory.nodeToInt(n);
    }

    private static boolean isInteger(int i) {
        return i != Integer.MIN_VALUE;
    }

    private static boolean isFloat(float f) {
        return f != Float.MIN_VALUE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HitConverter
    implements Map1<HitLARQ, Binding> {
        private Binding binding;
        private Var match;
        private Var score;

        HitConverter(Binding binding, Var matchVar, Var score) {
            this.binding = binding;
            this.match = matchVar;
            this.score = score;
        }

        public Binding map1(HitLARQ hit) {
            BindingMap b = new BindingMap(this.binding);
            b.add(this.match, hit.getNode());
            if (this.score != null) {
                b.add(this.score, NodeFactory.floatToNode(hit.getScore()));
            }
            return b;
        }
    }
}

