/*
 * (c) Copyright 2008, 2009 Hewlett-Packard Development Company, LP
 * All rights reserved.
 * [See end of file]
 */

package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.engine.OpEval;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.function.FunctionEnv;

public class E_Exists extends ExprFunction
{
    private static final String symbol = "exists" ;
    private Op op ;

    public E_Exists(Op op)
    {
        super(symbol) ;
        this.op = op  ;
    }

    @Override
    public Expr getArg(int i)
    {
        return null ;
    }

    @Override
    public int numArgs()
    {
        return 0 ;
    }

    @Override
    public Expr copySubstitute(Binding binding, boolean foldConstants)
    {
        return null ;
    }

    @Override
    public NodeValue eval(Binding binding, FunctionEnv env)
    {
        // XXX Dubious.  Need to get the OpExecutorFactory and that needs an ExecutionContext.
        // XXX Dubious.  QueryIterator tracking is lost.
        OpEval opExec = (OpEval)env.getContext().get(ARQConstants.sysCurrentOpExec) ;
        if ( opExec == null )
            throw new ARQInternalErrorException("No OpExec") ;
        QueryIterator qIter = opExec.eval(op, env.getDataset(), binding, env.getContext()) ;
        boolean b = qIter.hasNext() ;
        qIter.close() ;
        return NodeValue.booleanReturn(b) ;
    }

}

/*
 * (c) Copyright 2008, 2009 Hewlett-Packard Development Company, LP
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */