/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.binding;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingBase;
import java.util.Iterator;

public class BindingKey {
    public Binding key;
    public Binding value;
    private boolean validHashCode = false;
    private int keyHashCode = 0;
    private static final int EmptyBindingHashCode = 123;

    public BindingKey(Binding binding) {
        this(binding, binding);
    }

    public BindingKey(Binding keyBinding, Binding valueBinding) {
        this.key = keyBinding;
        this.value = valueBinding;
        this.hashCode();
    }

    public Binding getBinding() {
        return this.value;
    }

    public Binding getKey() {
        return this.key;
    }

    public int hashCode() {
        if (!this.validHashCode) {
            this.keyHashCode = BindingKey.calcHashCode(this.key);
            this.validHashCode = true;
        }
        return this.keyHashCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BindingKey)) {
            return false;
        }
        Binding binding2 = ((BindingKey)other).getKey();
        return BindingBase.equals(this.key, binding2);
    }

    private static int calcHashCode(Binding binding) {
        int calcHashCode = 123;
        Iterator iter = binding.vars();
        while (iter.hasNext()) {
            Var var = (Var)((Object)iter.next());
            Node n = binding.get(var);
            if (n == null) continue;
            calcHashCode = calcHashCode ^ n.hashCode() ^ var.hashCode();
        }
        return calcHashCode;
    }
}

