/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Variable;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class Var
extends Node_Variable {
    public static Var alloc(String varName) {
        return new Var(varName);
    }

    public static Var alloc(Node_Variable v) {
        if (v instanceof Var) {
            return (Var)v;
        }
        return new Var(v);
    }

    public static Var alloc(Node v) {
        if (v instanceof Var) {
            return (Var)v;
        }
        if (v instanceof Node_Variable) {
            return new Var((Node_Variable)v);
        }
        throw new NotAVariableException("Node: " + v);
    }

    public static Var alloc(ExprVar nv) {
        return new Var(nv);
    }

    public static Node lookup(Binding binding, Node node) {
        if (!Var.isVar(node)) {
            return node;
        }
        Var var = Var.alloc(node);
        return Var.lookup(binding, var);
    }

    public static Node lookup(Binding binding, Var var) {
        Node n = binding.get(var);
        if (n != null) {
            return n;
        }
        return var;
    }

    private Var(String varName) {
        super(varName);
    }

    private Var(Node_Variable v) {
        this(v.getName());
    }

    private Var(ExprVar v) {
        this(v.getVarName());
    }

    public Node asNode() {
        return this;
    }

    public String getVarName() {
        return this.getName();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Var)) {
            return false;
        }
        return super.equals(other);
    }

    public boolean isNamedVar() {
        return Var.isNamedVarName(this.getName());
    }

    public boolean isBlankNodeVar() {
        return Var.isBlankNodeVarName(this.getName());
    }

    public boolean isAllocVar() {
        return Var.isAllocVarName(this.getName());
    }

    public static String canonical(String x) {
        if (x.startsWith("?")) {
            return x.substring(1);
        }
        if (x.startsWith("$")) {
            return x.substring(1);
        }
        return x;
    }

    public static boolean isVar(Node node) {
        if (node instanceof Var) {
            return true;
        }
        if (node != null && node.isVariable()) {
            throw new NotAVariableException("Node_variable (not a Var) found");
        }
        return false;
    }

    public static boolean isNamedVar(Node node) {
        return node.isVariable() && Var.isNamedVarName(node.getName());
    }

    public static boolean isNamedVarName(String x) {
        return !Var.isBlankNodeVarName(x) && !Var.isAllocVarName(x);
    }

    public static boolean isBlankNodeVar(Node node) {
        return node.isVariable() && Var.isBlankNodeVarName(node.getName());
    }

    public static boolean isBlankNodeVarName(String x) {
        return x.startsWith("?");
    }

    public static boolean isAllocVar(Node node) {
        return node.isVariable() && Var.isAllocVarName(node.getName());
    }

    public static boolean isAllocVarName(String x) {
        return x.startsWith(".");
    }

    public static List varList(List varNames) {
        ArrayList<Var> x = new ArrayList<Var>();
        ListIterator iter = varNames.listIterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof String) {
                x.add(Var.alloc((String)obj));
                continue;
            }
            if (obj instanceof Var) {
                x.add((Var)((Object)obj));
                continue;
            }
            throw new ARQInternalErrorException("Element of a var list is not a string or a var: " + obj);
        }
        return x;
    }

    public static List varNames(Collection vars) {
        ArrayList<String> x = new ArrayList<String>();
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            String name = null;
            if (obj instanceof Var) {
                name = ((Var)((Object)obj)).getVarName();
            } else if (obj instanceof String) {
                name = (String)obj;
            } else {
                throw new ARQInternalErrorException("Element of a var list is not a string or a var: " + obj);
            }
            x.add(name);
        }
        return x;
    }

    public static void checkVarList(Collection varNames) {
        ArrayList x = new ArrayList();
        Iterator iter = varNames.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof Var) continue;
            if (obj instanceof String) {
                throw new ARQInternalErrorException("Element of a var list is a string: " + obj);
            }
            throw new ARQInternalErrorException("Element of a var list is not a string or a var: " + obj);
        }
    }

    public static Collection names(Collection vars) {
        ArrayList<String> x = new ArrayList<String>();
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof Var) {
                x.add(((Var)((Object)obj)).getVarName());
                continue;
            }
            if (obj instanceof String) {
                x.add((String)obj);
                continue;
            }
            throw new ARQInternalErrorException("Element of a var list is not a string or a var: " + obj);
        }
        return x;
    }

    static class NotAVariableException
    extends ARQInternalErrorException {
        NotAVariableException(String msg) {
            super(msg);
        }
    }
}

