/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.opt;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.op.OpLabel;
import com.hp.hpl.jena.sparql.algebra.opt.Rewrite;
import com.hp.hpl.jena.sparql.algebra.opt.TransformEqualityFilter;
import com.hp.hpl.jena.sparql.algebra.opt.TransformFilterImprove;
import com.hp.hpl.jena.sparql.algebra.opt.TransformFilterPlacement;
import com.hp.hpl.jena.sparql.algebra.opt.TransformPropertyFunction;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.util.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Optimize
implements Rewrite {
    private static Log log = LogFactory.getLog((Class)Optimize.class);
    public static Factory factory = new Factory(){

        public Rewrite create(Context context) {
            return new Optimize(context);
        }
    };
    private final Context context;

    private static Rewrite decideOptimizer(Context context) {
        if (factory == null) {
            return new Optimize(context);
        }
        return factory.create(context);
    }

    public static Op optimize(Op op, ExecutionContext execCxt) {
        return Optimize.optimize(op, execCxt.getContext());
    }

    public static Op optimize(Op op, Context context) {
        Rewrite opt = Optimize.decideOptimizer(context);
        return opt.rewrite(op);
    }

    private Optimize(ExecutionContext execCxt) {
        this(execCxt.getContext());
    }

    private Optimize(Context context) {
        this.context = context;
    }

    public Op rewrite(Op op) {
        op = Optimize.apply("Property Functions", new TransformPropertyFunction(this.context), op);
        op = Optimize.apply("Break up conjunctions", new TransformFilterImprove(), op);
        op = Optimize.apply("Filter Equality", new TransformEqualityFilter(), op);
        if (this.context.isTrueOrUndef(ARQ.filterPlacement)) {
            op = Optimize.apply("Filter Placement", new TransformFilterPlacement(), op);
        }
        op = OpLabel.create("Transformed", op);
        return op;
    }

    static Op apply(String label, Transform transform, Op op) {
        Op op2 = Transformer.transform(transform, op);
        boolean debug2 = false;
        return op2;
    }

    public static interface Factory {
        public Rewrite create(Context var1);
    }
}

