/*
 * (c) Copyright 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008 Hewlett-Packard Development Company, LP
 * [See end of file]
 */


package com.hp.hpl.jena.sparql.lang.rdql;
import com.hp.hpl.jena.query.Query;
;

public class SimpleNode implements RDQL_Node
{
  // These are manipulated by JJTree,JavaCC
  protected RDQL_Node parent;
  protected RDQL_Node[] children;

  protected int id;
  protected RDQLParser parser;

  // Used when created outside the parse tree (i.e. by ValueImpl())
  // dead - that use is coivered by WorkingVar
  //public SimpleNode() { id = -1 ; }

  public SimpleNode(int i) {
    id = i;
  }

  public SimpleNode(RDQLParser p, int i) {
    this(i);
    parser = p;
  }

  public void jjtOpen() {
  }

  public void jjtClose()
  {
  }

  public void jjtSetParent(RDQL_Node n) { parent = n; }
  public RDQL_Node jjtGetParent() { return parent; }

  public void jjtAddChild(RDQL_Node n, int i) {
    if (children == null) {
      children = new RDQL_Node[i + 1];
    } else if (i >= children.length) {
      RDQL_Node c[] = new RDQL_Node[i + 1];
      System.arraycopy(children, 0, c, 0, children.length);
      children = c;
    }
    children[i] = n;
  }

  public RDQL_Node jjtGetChild(int i) {
    return children[i];
  }

  public int jjtGetNumChildren() {
    return (children == null) ? 0 : children.length;
  }

  /* You can override these two methods in subclasses of SimpleNode to
     customize the way the node appears when the tree is dumped.  If
     your output uses more than one line you should override
     toString(String), otherwise overriding toString() is probably all
     you need to do. */

  public String toString() { return RDQLParserTreeConstants.jjtNodeName[id]; }
  public String toString(String prefix) { return prefix + toString(); }


  // Per-parse query processing
  // Operation to allow any node to do some alterations after the query has been parsed
  public void postParse2(Query query)
  {
      if (children != null)
      {
          for (int i = 0; i < children.length; ++i)
          {
              SimpleNode n = (SimpleNode)children[i];
              n.postParse2(query);
          }
      }
  }

  public void postParse1(Query query)
  {
      if (children != null)
      {
          for (int i = 0; i < children.length; ++i)
          {
              SimpleNode n = (SimpleNode)children[i];
              n.postParse1(query);
          }
      }
  }

  /* Override this method if you want to customize how the node dumps
     out its children. */

  public void dump(String prefix) {
    System.out.println(toString(prefix));
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        SimpleNode n = (SimpleNode)children[i];
        if (n != null) {
          n.dump(prefix + " ");
        }
      }
    }
  }
}

/*
 *  (c) Copyright 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008 Hewlett-Packard Development Company, LP
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
