/*
 * Decompiled with CFR 0.152.
 */
package arq.examples.larq;

import arq.examples.larq.ExLucene1;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.larq.IndexBuilderNode;
import com.hp.hpl.jena.query.larq.IndexLARQ;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.util.StringUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import java.io.Reader;
import java.io.StringReader;

public class ExLucene5 {
    public static void main(String[] a) throws Exception {
        System.out.println("ARQ Example: " + Utils.classShortName(ExLucene5.class));
        System.out.println("ARQ: " + ARQ.VERSION);
        System.out.println();
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = ExLucene5.buildIndexExternalContent(model);
        String searchString = "+document";
        String queryString = StringUtils.join((String)"\n", (String[])new String[]{"PREFIX pf:     <http://jena.hpl.hp.com/ARQ/property#>", "SELECT ?doc {", "    ?doc pf:textMatch '" + searchString + "'.", "}"});
        ExLucene1.performQuery(model, index, queryString);
        index.close();
    }

    static IndexLARQ buildIndexExternalContent(Model model) {
        IndexBuilderNode larqBuilder = new IndexBuilderNode();
        Resource r1 = ResourceFactory.createResource((String)"http://example/r1");
        Resource r2 = ResourceFactory.createResource((String)"http://example/r2");
        Resource r3 = ResourceFactory.createResource((String)"http://example/r3");
        Resource r4 = ResourceFactory.createResource((String)"http://example/r4");
        Literal lit1 = ResourceFactory.createPlainLiteral((String)"doc");
        larqBuilder.index((RDFNode)r1, (Reader)new StringReader("document"));
        larqBuilder.index((RDFNode)r2, "document");
        larqBuilder.index((RDFNode)r3, "slideshow");
        larqBuilder.index((RDFNode)r4, "codebase");
        larqBuilder.index((RDFNode)lit1, "document");
        larqBuilder.closeWriter();
        IndexLARQ index = larqBuilder.getIndex();
        return index;
    }
}

