/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import com.hp.hpl.jena.sparql.util.IndentedWriter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class Usage {
    List<Category> categories = new ArrayList<Category>();

    public Usage() {
        this.startCategory(null);
    }

    public void startCategory(String desc) {
        this.categories.add(new Category(desc));
    }

    public void addUsage(String argName, String msg) {
        this.current().entries.add(new Entry(argName, msg));
    }

    public void output(PrintStream out) {
        this.output(new IndentedWriter((OutputStream)out));
    }

    public void output(IndentedWriter out) {
        int INDENT1 = 2;
        int INDENT2 = 4;
        out.incIndent(INDENT1);
        for (Category c : this.categories) {
            if (c.desc != null) {
                out.println((Object)c.desc);
            }
            out.incIndent(INDENT2);
            for (Entry e : c.entries) {
                out.print((Object)e.arg);
                if (e.msg != null) {
                    out.pad(20);
                    out.print((Object)"   ");
                    out.print((Object)e.msg);
                }
                out.println();
            }
            out.decIndent(INDENT2);
        }
        out.decIndent(INDENT1);
        out.flush();
    }

    private Category current() {
        return this.categories.get(this.categories.size() - 1);
    }

    class Entry {
        String arg;
        String msg;

        Entry(String arg, String msg) {
            this.arg = arg;
            this.msg = msg;
        }
    }

    class Category {
        String desc;
        List<Entry> entries = new ArrayList<Entry>();

        Category(String desc) {
            this.desc = desc;
        }
    }
}

