/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.io.OutputStream;
import java.io.PrintStream;

public class ModSymbol
implements ArgModuleGeneral {
    protected final ArgDecl setDecl = new ArgDecl(true, "set", "define", "defn", "def");
    Context context = new Context();
    private String namespace;
    public static PrefixMapping symbolPrefixMapping = new PrefixMappingImpl();

    public ModSymbol() {
        this("arq");
    }

    public ModSymbol(String namespace) {
        this.namespace = namespace;
    }

    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Symbol definition");
        cmdLine.add(this.setDecl, "--set", "Set a configuration symbol to a value");
    }

    public void checkCommandLine(CmdArgModule cmdLine) {
    }

    public static void addPrefixMapping(String prefix, String uri) {
        symbolPrefixMapping.setNsPrefix(prefix, uri);
    }

    public void processArgs(CmdArgModule cmdLine) {
        if (cmdLine.getValues(this.setDecl) == null || cmdLine.getValues(this.setDecl).size() == 0) {
            return;
        }
        for (String arg : cmdLine.getValues(this.setDecl)) {
            String[] frags = arg.split("=", 2);
            if (frags.length != 2) {
                throw new RuntimeException("Can't split '" + arg + "'");
            }
            String symbolName = frags[0];
            String value = frags[1];
            symbolName = symbolPrefixMapping.expandPrefix(symbolName);
            Symbol symbol = Symbol.create((String)symbolName);
            this.context.set(symbol, (Object)value);
        }
        ARQ.getContext().setAll(this.context);
    }

    public void verbose() {
        this.verbose(System.out);
    }

    public void verbose(PrintStream stream) {
        IndentedWriter out = new IndentedWriter((OutputStream)stream);
        this.verbose(out);
        out.flush();
    }

    public void verbose(IndentedWriter out) {
        for (Symbol symbol : this.context.keys()) {
            String value = this.context.getAsString(symbol);
            out.println((Object)(symbol + " -> " + value));
        }
    }
}

