/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import playn.core.TextFormat;
import playn.java.JavaCanvasState;
import playn.java.JavaFont;

class JavaTextLayout
implements playn.core.TextLayout {
    private float width;
    private float height;
    private TextFormat format;
    private List<TextLayout> layouts = new ArrayList<TextLayout>();
    private Color textColor;
    private Color altColor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaTextLayout(Frame frame, String text, TextFormat format) {
        FontRenderContext fctx;
        this.format = format;
        this.textColor = JavaCanvasState.convertColor(format.textColor);
        Integer altARGB = format.effect.getAltColor();
        if (altARGB != null) {
            this.altColor = JavaCanvasState.convertColor(altARGB);
        }
        text = text.replace("\r\n", "\n").replace('\r', '\n');
        AttributedString astring = new AttributedString(text);
        if (format.font != null) {
            astring.addAttribute(TextAttribute.FONT, ((JavaFont)format.font).jfont);
        }
        Graphics2D gfx = (Graphics2D)frame.getGraphics();
        try {
            fctx = gfx.getFontRenderContext();
        }
        finally {
            gfx.dispose();
            gfx = null;
        }
        if (format.shouldWrap() || text.indexOf(10) != -1) {
            LineBreakMeasurer measurer = new LineBreakMeasurer(astring.getIterator(), fctx);
            int eol = 10;
            int lastPos = text.length();
            while (measurer.getPosition() < lastPos) {
                int nextRet = text.indexOf(eol, measurer.getPosition() + 1);
                if (nextRet == -1) {
                    nextRet = lastPos;
                }
                this.layouts.add(measurer.nextLayout(format.wrapWidth, nextRet, false));
            }
        } else {
            this.layouts.add(new TextLayout(astring.getIterator(), fctx));
        }
        float twidth = 0.0f;
        float theight = 0.0f;
        for (TextLayout layout : this.layouts) {
            Rectangle2D bounds = layout.getBounds();
            twidth = Math.max(twidth, this.getWidth(bounds));
            if (layout != this.layouts.get(0)) {
                theight += layout.getLeading();
            }
            theight += layout.getAscent() + layout.getDescent();
        }
        this.width = format.effect.adjustWidth(twidth);
        this.height = format.effect.adjustHeight(theight);
    }

    public float width() {
        return this.width;
    }

    public float height() {
        return this.height;
    }

    public int lineCount() {
        return this.layouts.size();
    }

    public TextFormat format() {
        return this.format;
    }

    void paint(Graphics2D gfx, float x, float y) {
        Color ocolor = gfx.getColor();
        if (this.format.effect instanceof TextFormat.Effect.Shadow) {
            float sy;
            float ty;
            float sx;
            float tx;
            TextFormat.Effect.Shadow seffect = (TextFormat.Effect.Shadow)this.format.effect;
            if (seffect.shadowOffsetX > 0.0f) {
                tx = 0.0f;
                sx = seffect.shadowOffsetX;
            } else {
                tx = -seffect.shadowOffsetX;
                sx = 0.0f;
            }
            if (seffect.shadowOffsetY > 0.0f) {
                ty = 0.0f;
                sy = seffect.shadowOffsetY;
            } else {
                ty = -seffect.shadowOffsetY;
                sy = 0.0f;
            }
            gfx.setColor(this.altColor);
            this.paintOnce(gfx, x + sx, y + sy);
            gfx.setColor(this.textColor);
            this.paintOnce(gfx, x + tx, y + ty);
        } else if (this.format.effect instanceof TextFormat.Effect.Outline) {
            gfx.setColor(this.altColor);
            this.paintOnce(gfx, x + 0.0f, y + 0.0f);
            this.paintOnce(gfx, x + 0.0f, y + 1.0f);
            this.paintOnce(gfx, x + 0.0f, y + 2.0f);
            this.paintOnce(gfx, x + 1.0f, y + 0.0f);
            this.paintOnce(gfx, x + 1.0f, y + 2.0f);
            this.paintOnce(gfx, x + 2.0f, y + 0.0f);
            this.paintOnce(gfx, x + 2.0f, y + 1.0f);
            this.paintOnce(gfx, x + 2.0f, y + 2.0f);
            gfx.setColor(this.textColor);
            this.paintOnce(gfx, x + 1.0f, y + 1.0f);
        } else {
            gfx.setColor(this.textColor);
            this.paintOnce(gfx, x, y);
        }
        gfx.setColor(ocolor);
    }

    void paintOnce(Graphics2D gfx, float x, float y) {
        float yoff = 0.0f;
        for (TextLayout layout : this.layouts) {
            Rectangle2D bounds = layout.getBounds();
            float rx = (float)(-bounds.getX()) + this.format.align.getX(this.getWidth(bounds), this.width);
            layout.draw(gfx, x + rx, y + (yoff += layout.getAscent()));
            if (layout != this.layouts.get(0)) {
                yoff += layout.getLeading();
            }
            yoff += layout.getDescent();
        }
    }

    float getWidth(Rectangle2D bounds) {
        return (float)(Math.max(-bounds.getX(), 0.0) + bounds.getWidth());
    }
}

