/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.io.StringWriter;
import java.util.Arrays;
import playn.core.Json;
import playn.core.TypedArrayBuilder;
import playn.java.json.JSONArray;
import playn.java.json.JSONException;
import playn.java.json.JSONObject;
import playn.java.json.JSONWriter;

public class JavaJson
implements Json {
    private static TypedArrayBuilder<JSONArray> arrayBuilder = new TypedArrayBuilder<JSONArray>(){

        public int length(JSONArray array) {
            return array.length();
        }

        public Json.Object getObject(JSONArray array, int index) {
            JSONObject o = array.optJSONObject(index);
            return o == null ? null : new JavaObject(o);
        }

        public Boolean getBoolean(JSONArray array, int index) {
            return array.optBoolean(index);
        }

        public Integer getInt(JSONArray array, int index) {
            return array.optInt(index);
        }

        public Double getNumber(JSONArray array, int index) {
            return array.optDouble(index);
        }

        public String getString(JSONArray array, int index) {
            return array.optString(index);
        }
    };

    public Json.Writer newWriter() {
        return new JavaWriter();
    }

    public Json.Object parse(String json) {
        try {
            return new JavaObject(new JSONObject(json));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    static class JavaArray
    implements Json.Array {
        private JSONArray jsa;

        JavaArray(JSONArray jsa) {
            this.jsa = jsa;
        }

        public int length() {
            return this.jsa.length();
        }

        public boolean getBoolean(int index) {
            return this.jsa.optBoolean(index);
        }

        public int getInt(int index) {
            return this.jsa.optInt(index);
        }

        public double getNumber(int index) {
            return this.jsa.optDouble(index);
        }

        public String getString(int index) {
            return this.jsa.optString(index);
        }

        public Json.Object getObject(int index) {
            JSONObject o = this.jsa.optJSONObject(index);
            return o == null ? null : new JavaObject(o);
        }

        public Json.Array getArray(int index) {
            JSONArray a = this.jsa.optJSONArray(index);
            return a == null ? null : new JavaArray(a);
        }

        public <T> Json.TypedArray<T> getArray(int index, Class<T> arrayType) {
            return arrayBuilder.build((Object)this.jsa.optJSONArray(index), arrayType);
        }
    }

    static class JavaObject
    implements Json.Object {
        private JSONObject jso;

        JavaObject(JSONObject jso) {
            this.jso = jso;
        }

        public boolean getBoolean(String key) {
            return this.jso.optBoolean(key);
        }

        public int getInt(String key) {
            return this.jso.optInt(key);
        }

        public double getNumber(String key) {
            return this.jso.optDouble(key);
        }

        public String getString(String key) {
            return this.jso.optString(key);
        }

        public Json.Object getObject(String key) {
            JSONObject o = this.jso.optJSONObject(key);
            return o == null ? null : new JavaObject(o);
        }

        public Json.Array getArray(String key) {
            JSONArray a = this.jso.optJSONArray(key);
            return a == null ? null : new JavaArray(a);
        }

        public <T> Json.TypedArray<T> getArray(String key, Class<T> arrayType) {
            return arrayBuilder.build((Object)this.jso.optJSONArray(key), arrayType);
        }

        public boolean containsKey(String key) {
            return this.jso == null ? false : this.jso.has(key);
        }

        public Json.TypedArray<String> getKeys() {
            String[] names;
            if (this.jso == null || (names = JSONObject.getNames(this.jso)) == null) {
                return arrayBuilder.build((Object)new JSONArray(), String.class);
            }
            return arrayBuilder.build((Object)new JSONArray(Arrays.asList(names)), String.class);
        }
    }

    static class JavaWriter
    implements Json.Writer {
        private StringWriter sw;
        private JSONWriter w;

        JavaWriter() {
            this.reset();
        }

        public Json.Writer key(String key) {
            try {
                this.w.key(key);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Json.Writer value(boolean x) {
            try {
                this.w.value(x);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Json.Writer value(int x) {
            try {
                this.w.value(x);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Json.Writer value(double x) {
            try {
                this.w.value(x);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Json.Writer value(String x) {
            try {
                this.w.value(x);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Json.Writer object() {
            try {
                this.w.object();
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Json.Writer endObject() {
            try {
                this.w.endObject();
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Json.Writer array() {
            try {
                this.w.array();
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Json.Writer endArray() {
            try {
                this.w.endArray();
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public String write() {
            String result = this.sw.toString();
            this.reset();
            return result;
        }

        private void reset() {
            this.sw = new StringWriter();
            this.w = new JSONWriter(this.sw);
        }
    }
}

