/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import playn.core.Asserts;
import playn.core.CanvasImage;
import playn.core.CanvasLayer;
import playn.core.Font;
import playn.core.Gradient;
import playn.core.Graphics;
import playn.core.GroupLayer;
import playn.core.Image;
import playn.core.ImageLayer;
import playn.core.Path;
import playn.core.Pattern;
import playn.core.SurfaceLayer;
import playn.core.TextFormat;
import playn.core.TextLayout;
import playn.java.JavaCanvasLayer;
import playn.java.JavaFont;
import playn.java.JavaGradient;
import playn.java.JavaGroupLayer;
import playn.java.JavaImage;
import playn.java.JavaImageLayer;
import playn.java.JavaPath;
import playn.java.JavaPattern;
import playn.java.JavaSurfaceLayer;
import playn.java.JavaTextLayout;

class JavaGraphics
implements Graphics {
    private final Component component;
    private final JavaGroupLayer rootLayer;
    private final JFrame frame;

    JavaGraphics(JFrame frame, Component component) {
        this.frame = frame;
        this.component = component;
        this.rootLayer = new JavaGroupLayer();
    }

    public CanvasLayer createCanvasLayer(int width, int height) {
        return new JavaCanvasLayer(width, height);
    }

    public GroupLayer createGroupLayer() {
        return new JavaGroupLayer();
    }

    public ImageLayer createImageLayer() {
        return new JavaImageLayer();
    }

    public ImageLayer createImageLayer(Image image) {
        Asserts.checkArgument((boolean)(image instanceof JavaImage));
        return new JavaImageLayer((JavaImage)image);
    }

    public SurfaceLayer createSurfaceLayer(int width, int height) {
        return new JavaSurfaceLayer(width, height);
    }

    public JavaGroupLayer rootLayer() {
        return this.rootLayer;
    }

    public CanvasImage createImage(int w, int h) {
        return new JavaImage(new BufferedImage(w, h, 2));
    }

    public Gradient createLinearGradient(float x0, float y0, float x1, float y1, int[] colors, float[] positions) {
        return JavaGradient.createLinear(x0, y0, x1, y1, positions, colors);
    }

    public Path createPath() {
        return new JavaPath();
    }

    public Pattern createPattern(Image img) {
        return JavaPattern.create((JavaImage)img);
    }

    public Gradient createRadialGradient(float x, float y, float r, int[] colors, float[] positions) {
        return JavaGradient.createRadial(x, y, r, positions, colors);
    }

    public Font createFont(String name, Font.Style style, float size) {
        return new JavaFont(name, style, size);
    }

    public TextLayout layoutText(String text, TextFormat format) {
        return new JavaTextLayout(this.frame, text, format);
    }

    public int screenWidth() {
        return this.component.getWidth();
    }

    public int screenHeight() {
        return this.component.getHeight();
    }

    public int width() {
        return this.component.getWidth();
    }

    public int height() {
        return this.component.getHeight();
    }

    public void setSize(int width, int height) {
        this.component.setPreferredSize(new Dimension(width, height));
        this.frame.pack();
    }
}

