/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import playn.core.AbstractAssetManager;
import playn.core.Image;
import playn.core.PlayN;
import playn.core.ResourceCallback;
import playn.core.Sound;
import playn.java.JavaAudio;
import playn.java.JavaImage;

public class JavaAssetManager
extends AbstractAssetManager {
    private String pathPrefix = "";

    public void setPathPrefix(String prefix) {
        if (prefix.startsWith("/") || prefix.endsWith("/")) {
            throw new IllegalArgumentException("Prefix must not start or end with '/'.");
        }
        this.pathPrefix = prefix.length() == 0 ? prefix : prefix + "/";
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    protected Image doGetImage(String path) {
        try {
            return new JavaImage(ImageIO.read(this.requireResource(this.pathPrefix + path)));
        }
        catch (Exception e) {
            PlayN.log().warn("Could not load image at " + this.pathPrefix + path, (Throwable)e);
            return new JavaImage(e);
        }
    }

    protected Sound doGetSound(String path) {
        path = path + ".mp3";
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.pathPrefix + path);
        if (in == null) {
            PlayN.log().warn("Could not find sound " + this.pathPrefix + path);
            return ((JavaAudio)PlayN.audio()).createNoopSound();
        }
        return ((JavaAudio)PlayN.audio()).createSound(path, in);
    }

    protected void doGetText(String path, ResourceCallback<String> callback) {
        try {
            callback.done((Object)Resources.toString((URL)this.requireResource(this.pathPrefix + path), (Charset)Charsets.UTF_8));
        }
        catch (Exception e) {
            callback.error((Throwable)e);
        }
    }

    protected URL requireResource(String path) throws FileNotFoundException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(path);
        if (url == null) {
            throw new FileNotFoundException(path);
        }
        return url;
    }
}

