/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import playn.core.Canvas;
import playn.java.JavaGradient;
import playn.java.JavaPath;
import playn.java.JavaPattern;

class JavaCanvasState {
    int fillColor;
    int strokeColor;
    JavaGradient fillGradient;
    JavaPattern fillPattern;
    AffineTransform transform;
    float strokeWidth;
    Canvas.LineCap lineCap;
    Canvas.LineJoin lineJoin;
    float miterLimit;
    JavaPath clip;
    Canvas.Composite composite;
    float alpha;

    JavaCanvasState() {
        this(-16777216, -1, null, null, new AffineTransform(), 1.0f, Canvas.LineCap.SQUARE, Canvas.LineJoin.MITER, 10.0f, null, Canvas.Composite.SRC_OVER, 1.0f);
    }

    JavaCanvasState(JavaCanvasState toCopy) {
        this(toCopy.fillColor, toCopy.strokeColor, toCopy.fillGradient, toCopy.fillPattern, toCopy.transform, toCopy.strokeWidth, toCopy.lineCap, toCopy.lineJoin, toCopy.miterLimit, toCopy.clip, toCopy.composite, toCopy.alpha);
    }

    JavaCanvasState(int fillColor, int strokeColor, JavaGradient fillGradient, JavaPattern fillPattern, AffineTransform transform, float strokeWidth, Canvas.LineCap lineCap, Canvas.LineJoin lineJoin, float miterLimit, JavaPath clip, Canvas.Composite composite, float alpha) {
        this.fillColor = fillColor;
        this.strokeColor = strokeColor;
        this.fillGradient = fillGradient;
        this.fillPattern = fillPattern;
        this.transform = transform;
        this.strokeWidth = strokeWidth;
        this.lineCap = lineCap;
        this.lineJoin = lineJoin;
        this.miterLimit = miterLimit;
        this.composite = composite;
        this.alpha = alpha;
    }

    void prepareStroke(Graphics2D gfx) {
        gfx.setStroke(new BasicStroke(this.strokeWidth, this.convertLineCap(), this.convertLineJoin(), this.miterLimit));
        gfx.setColor(JavaCanvasState.convertColor(this.strokeColor));
        gfx.setClip(this.clip != null ? this.clip.path : null);
        gfx.setComposite(this.convertComposite(this.composite, this.alpha));
    }

    void prepareFill(Graphics2D gfx) {
        if (this.fillGradient != null) {
            gfx.setPaint(this.fillGradient.paint);
        } else if (this.fillPattern != null) {
            this.fillPattern.updateSize();
            gfx.setPaint(this.fillPattern.paint);
        } else {
            gfx.setPaint(JavaCanvasState.convertColor(this.fillColor));
        }
        gfx.setClip(this.clip != null ? this.clip.path : null);
        gfx.setComposite(this.convertComposite(this.composite, this.alpha));
    }

    static Color convertColor(int color) {
        float a = (float)(color >>> 24) / 255.0f;
        float r = (float)(color >>> 16 & 0xFF) / 255.0f;
        float g = (float)(color >>> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new Color(r, g, b, a);
    }

    private Composite convertComposite(Canvas.Composite composite, float alpha) {
        AlphaComposite ret;
        switch (composite) {
            case DST_ATOP: {
                ret = AlphaComposite.DstAtop;
                break;
            }
            case DST_IN: {
                ret = AlphaComposite.DstIn;
                break;
            }
            case DST_OUT: {
                ret = AlphaComposite.DstOut;
                break;
            }
            case DST_OVER: {
                ret = AlphaComposite.DstOver;
                break;
            }
            case SRC: {
                ret = AlphaComposite.Src;
                break;
            }
            case SRC_ATOP: {
                ret = AlphaComposite.SrcAtop;
                break;
            }
            case SRC_IN: {
                ret = AlphaComposite.SrcIn;
                break;
            }
            case SRC_OUT: {
                ret = AlphaComposite.SrcOut;
                break;
            }
            case SRC_OVER: {
                ret = AlphaComposite.SrcOver;
                break;
            }
            case XOR: {
                ret = AlphaComposite.Xor;
                break;
            }
            default: {
                ret = AlphaComposite.Src;
            }
        }
        if (alpha != 1.0f) {
            return ret.derive(alpha);
        }
        return ret;
    }

    private int convertLineCap() {
        switch (this.lineCap) {
            case BUTT: {
                return 0;
            }
            case ROUND: {
                return 1;
            }
            case SQUARE: {
                return 2;
            }
        }
        return 2;
    }

    private int convertLineJoin() {
        switch (this.lineJoin) {
            case BEVEL: {
                return 2;
            }
            case MITER: {
                return 0;
            }
            case ROUND: {
                return 1;
            }
        }
        return 0;
    }
}

