/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Deque;
import java.util.LinkedList;
import playn.core.Asserts;
import playn.core.Canvas;
import playn.core.Gradient;
import playn.core.Image;
import playn.core.Path;
import playn.core.Pattern;
import playn.core.TextLayout;
import playn.java.JavaCanvasState;
import playn.java.JavaGradient;
import playn.java.JavaImage;
import playn.java.JavaPath;
import playn.java.JavaPattern;
import playn.java.JavaTextLayout;

class JavaCanvas
implements Canvas {
    final Graphics2D gfx;
    private final int width;
    private final int height;
    private Deque<JavaCanvasState> stateStack = new LinkedList<JavaCanvasState>();
    private Ellipse2D.Float ellipse = new Ellipse2D.Float();
    private Line2D.Float line = new Line2D.Float();
    private Rectangle2D.Float rect = new Rectangle2D.Float();

    JavaCanvas(Graphics2D graphics, int width, int height) {
        this.gfx = graphics;
        this.width = width;
        this.height = height;
        this.stateStack.push(new JavaCanvasState());
        this.gfx.setBackground(new Color(0, true));
    }

    public float alpha() {
        return this.currentState().alpha;
    }

    public Canvas clear() {
        this.gfx.clearRect(0, 0, this.width, this.height);
        return this;
    }

    public Canvas clip(Path path) {
        Asserts.checkArgument((boolean)(path instanceof JavaPath));
        this.currentState().clip = (JavaPath)path;
        return this;
    }

    public Canvas drawImage(Image img, float x, float y) {
        Asserts.checkArgument((boolean)(img instanceof JavaImage));
        JavaImage jimg = (JavaImage)img;
        this.currentState().prepareFill(this.gfx);
        int dx = (int)x;
        int dy = (int)y;
        int w = jimg.width();
        int h = jimg.height();
        this.gfx.drawImage(jimg.img, dx, dy, dx + w, dy + h, 0, 0, w, h, null);
        return this;
    }

    public Canvas drawImageCentered(Image img, float x, float y) {
        this.drawImage(img, x - (float)(img.width() / 2), y - (float)(img.height() / 2));
        return this;
    }

    public Canvas drawImage(Image img, float x, float y, float w, float h) {
        Asserts.checkArgument((boolean)(img instanceof JavaImage));
        JavaImage jimg = (JavaImage)img;
        AffineTransform tx = new AffineTransform(w / (float)jimg.width(), 0.0f, 0.0f, h / (float)jimg.height(), x, y);
        this.currentState().prepareFill(this.gfx);
        this.gfx.drawImage(jimg.img, tx, null);
        return this;
    }

    public Canvas drawImage(Image img, float dx, float dy, float dw, float dh, float sx, float sy, float sw, float sh) {
        Asserts.checkArgument((boolean)(img instanceof JavaImage));
        JavaImage jimg = (JavaImage)img;
        this.currentState().prepareFill(this.gfx);
        this.gfx.drawImage(jimg.img, (int)dx, (int)dy, (int)(dx + dw), (int)(dy + dh), (int)sx, (int)sy, (int)(sx + sw), (int)(sy + sh), null);
        return this;
    }

    public Canvas drawLine(float x0, float y0, float x1, float y1) {
        this.currentState().prepareStroke(this.gfx);
        this.line.setLine(x0, y0, x1, y1);
        this.gfx.draw(this.line);
        return this;
    }

    public Canvas drawPoint(float x, float y) {
        this.currentState().prepareStroke(this.gfx);
        this.gfx.drawLine((int)x, (int)y, (int)x, (int)y);
        return this;
    }

    public Canvas drawText(String text, float x, float y) {
        this.currentState().prepareFill(this.gfx);
        this.gfx.drawString(text, x, y);
        return this;
    }

    public Canvas drawText(TextLayout layout, float x, float y) {
        this.currentState().prepareFill(this.gfx);
        ((JavaTextLayout)layout).paint(this.gfx, x, y);
        return this;
    }

    public Canvas fillCircle(float x, float y, float radius) {
        this.currentState().prepareFill(this.gfx);
        this.ellipse.setFrame(x - radius, y - radius, 2.0f * radius, 2.0f * radius);
        this.gfx.fill(this.ellipse);
        return this;
    }

    public Canvas fillPath(Path path) {
        Asserts.checkArgument((boolean)(path instanceof JavaPath));
        this.currentState().prepareFill(this.gfx);
        this.gfx.fill(((JavaPath)path).path);
        return this;
    }

    public Canvas fillRect(float x, float y, float width, float height) {
        this.currentState().prepareFill(this.gfx);
        this.rect.setRect(x, y, width, height);
        this.gfx.fill(this.rect);
        return this;
    }

    public int height() {
        return this.height;
    }

    public Canvas restore() {
        this.stateStack.pop();
        this.gfx.setTransform(this.currentState().transform);
        return this;
    }

    public Canvas rotate(float angle) {
        this.gfx.rotate(angle);
        return this;
    }

    public Canvas save() {
        this.currentState().transform = this.gfx.getTransform();
        this.stateStack.push(new JavaCanvasState(this.currentState()));
        return this;
    }

    public Canvas scale(float x, float y) {
        this.gfx.scale(x, y);
        return this;
    }

    public Canvas setAlpha(float alpha) {
        this.currentState().alpha = alpha;
        return this;
    }

    public Canvas setCompositeOperation(Canvas.Composite composite) {
        this.currentState().composite = composite;
        return this;
    }

    public Canvas setFillColor(int color) {
        this.currentState().fillColor = color;
        this.currentState().fillGradient = null;
        this.currentState().fillPattern = null;
        return this;
    }

    public Canvas setFillGradient(Gradient gradient) {
        Asserts.checkArgument((boolean)(gradient instanceof JavaGradient));
        this.currentState().fillGradient = (JavaGradient)gradient;
        this.currentState().fillPattern = null;
        this.currentState().fillColor = 0;
        return this;
    }

    public Canvas setFillPattern(Pattern pattern) {
        Asserts.checkArgument((boolean)(pattern instanceof JavaPattern));
        this.currentState().fillPattern = (JavaPattern)pattern;
        this.currentState().fillGradient = null;
        this.currentState().fillColor = 0;
        return this;
    }

    public Canvas setLineCap(Canvas.LineCap cap) {
        this.currentState().lineCap = cap;
        return this;
    }

    public Canvas setLineJoin(Canvas.LineJoin join) {
        this.currentState().lineJoin = join;
        return this;
    }

    public Canvas setMiterLimit(float miter) {
        this.currentState().miterLimit = miter;
        return this;
    }

    public Canvas setStrokeColor(int color) {
        this.currentState().strokeColor = color;
        return this;
    }

    public Canvas setStrokeWidth(float w) {
        this.currentState().strokeWidth = w;
        return this;
    }

    public Canvas setTransform(float m11, float m12, float m21, float m22, float dx, float dy) {
        this.gfx.setTransform(new AffineTransform(m11, m12, m21, m22, dx, dy));
        return this;
    }

    public Canvas strokeCircle(float x, float y, float radius) {
        this.currentState().prepareStroke(this.gfx);
        this.ellipse.setFrame(x - radius, y - radius, 2.0f * radius, 2.0f * radius);
        this.gfx.draw(this.ellipse);
        return this;
    }

    public Canvas strokePath(Path path) {
        this.currentState().prepareStroke(this.gfx);
        this.gfx.setColor(new Color(this.currentState().strokeColor, false));
        this.gfx.draw(((JavaPath)path).path);
        return this;
    }

    public Canvas strokeRect(float x, float y, float width, float height) {
        this.currentState().prepareStroke(this.gfx);
        this.rect.setRect(x, y, width, height);
        this.gfx.draw(this.rect);
        return this;
    }

    public Canvas transform(float m11, float m12, float m21, float m22, float dx, float dy) {
        this.gfx.transform(new AffineTransform(m11, m12, m21, m22, dx, dy));
        return this;
    }

    public Canvas translate(float x, float y) {
        this.gfx.translate(x, y);
        return this;
    }

    public int width() {
        return this.width;
    }

    private JavaCanvasState currentState() {
        return this.stateStack.getFirst();
    }
}

