/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.distributed;

import java.util.HashSet;
import java.util.Iterator;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.distributed.Communicator;
import no.uib.cipr.matrix.distributed.DistMatrix;
import no.uib.cipr.matrix.distributed.DistVector;
import no.uib.cipr.matrix.distributed.Reductions;

@Deprecated
public class DistRowMatrix
extends DistMatrix {
    private static final long serialVersionUID = 3258129167668229176L;

    public DistRowMatrix(int numRows, int numColumns, Communicator comm, Matrix A, Matrix B) {
        super(numRows, numColumns, comm, A, B);
        if (A.numRows() != B.numRows()) {
            throw new IllegalArgumentException("A.numRows() != B.numRows()");
        }
        if (B.numColumns() != numColumns) {
            throw new IllegalArgumentException("B.numColumns() != numColumns");
        }
    }

    @Override
    public void add(int row, int column, double value) {
        this.check(row, column);
        if (this.inA(row, column)) {
            this.A.add(row - this.n[this.rank], column - this.m[this.rank], value);
        } else if (this.local(row, column)) {
            this.B.add(row - this.n[this.rank], column, value);
        } else {
            throw new IllegalArgumentException("Row index " + row + " is not local");
        }
    }

    @Override
    public void set(int row, int column, double value) {
        this.check(row, column);
        if (this.inA(row, column)) {
            this.A.set(row - this.n[this.rank], column - this.m[this.rank], value);
        } else if (this.local(row, column)) {
            this.B.set(row - this.n[this.rank], column, value);
        } else {
            throw new IllegalArgumentException("Row index " + row + " is not local");
        }
    }

    @Override
    public double get(int row, int column) {
        this.check(row, column);
        if (this.inA(row, column)) {
            return this.A.get(row - this.n[this.rank], column - this.m[this.rank]);
        }
        if (this.local(row, column)) {
            return this.B.get(row - this.n[this.rank], column);
        }
        throw new IndexOutOfBoundsException("Entry not available locally");
    }

    @Override
    public DistRowMatrix copy() {
        return new DistRowMatrix(this.numRows, this.numColumns, this.comm, this.A.copy(), this.B.copy());
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new DistMatrix.DistMatrixIterator(this.n[this.rank], this.m[this.rank], this.n[this.rank], 0);
    }

    @Override
    public Vector multAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DistVector) || !(y instanceof DistVector)) {
            throw new IllegalArgumentException("Vectors must be DistVectors");
        }
        this.checkMultAdd(x, y);
        DistVector xd = (DistVector)x;
        DistVector yd = (DistVector)y;
        this.scatter.startScatter(xd, this.locC);
        this.A.multAdd(alpha, xd.getLocal(), yd.getLocal());
        this.scatter.endSetScatter(xd, this.locC);
        this.B.multAdd(alpha, this.locC, yd.getLocal());
        return y;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DistVector) || !(y instanceof DistVector)) {
            throw new IllegalArgumentException("Vectors must be DistVectors");
        }
        this.checkTransMultAdd(x, y);
        y.scale(1.0 / alpha);
        DistVector xd = (DistVector)x;
        DistVector yd = (DistVector)y;
        this.B.transMult(xd.getLocal(), this.locR);
        this.scatter.startGather(this.locR, yd);
        this.A.transMultAdd(xd.getLocal(), yd.getLocal());
        this.scatter.endAddGather(this.locR, yd);
        return y.scale(alpha);
    }

    @Override
    public boolean local(int row, int column) {
        return row >= this.n[this.rank] && row < this.n[this.rank + 1];
    }

    int getRank(int row) {
        int i;
        for (i = 1; i < this.n.length && row >= this.n[i]; ++i) {
        }
        return i - 1;
    }

    @Override
    int[] getDelimiter() {
        return this.n;
    }

    @Override
    int[] getCommIndices() {
        HashSet<Integer> set = new HashSet<Integer>();
        for (MatrixEntry e : this.B) {
            if (this.local(e.column(), e.column())) continue;
            set.add(e.column());
        }
        int[] indices = new int[set.size()];
        int j = 0;
        for (Integer i : set) {
            indices[j++] = i;
        }
        return indices;
    }

    @Override
    protected double norm1() {
        double norm = super.norm1();
        double[] recv = new double[1];
        this.comm.allReduce(new double[]{norm}, recv, Reductions.max());
        return recv[0];
    }

    @Override
    protected double normInf() {
        double[] columnSum = new double[this.numColumns];
        for (MatrixEntry e : this) {
            int n = e.column();
            columnSum[n] = columnSum[n] + Math.abs(e.get());
        }
        double[] recv = new double[this.numColumns];
        this.comm.allReduce(columnSum, recv, Reductions.sum());
        return this.max(recv);
    }

    @Override
    public DistRowMatrix zero() {
        super.zero();
        return this;
    }
}

