/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.gj;

import org.ejml.alg.dense.decomposition.SingularMatrixException;
import org.ejml.alg.dense.linsol.LinearSolverAbstract;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RowD1Matrix64F;

public class GaussJordan
extends LinearSolverAbstract {
    private int[] ipiv;
    private int[] indexRow;
    private int[] indexCol;

    public GaussJordan(int dimen) {
        this.ipiv = new int[dimen];
        this.indexRow = new int[dimen];
        this.indexCol = new int[dimen];
    }

    @Override
    public boolean setA(DenseMatrix64F A) {
        this._setA(A);
        return true;
    }

    @Override
    public double quality() {
        throw new IllegalArgumentException("Not supported by this solver.");
    }

    public static void checkArgumentSquare(RowD1Matrix64F mat, String name) {
        if (mat.numCols != mat.numRows) {
            throw new IllegalArgumentException("'" + name + "' must be a square matrix.");
        }
    }

    @Override
    public void invert(DenseMatrix64F A) {
        int i;
        GaussJordan.checkArgumentSquare(A, "A");
        if (A != this.A) {
            A.set(this.A);
        }
        int N = A.numCols;
        for (i = 0; i < N; ++i) {
            this.ipiv[i] = 0;
        }
        for (i = 0; i < N; ++i) {
            double bestVal = 0.0;
            int bestRow = -1;
            int bestCol = -1;
            for (int j = 0; j < N; ++j) {
                if (this.ipiv[j] == 1) continue;
                for (int k = 0; k < N; ++k) {
                    if (this.ipiv[k] != 0) continue;
                    double val = A.unsafe_get(j, k);
                    if (val < 0.0) {
                        val = -val;
                    }
                    if (!(val > bestVal)) continue;
                    bestVal = val;
                    bestRow = j;
                    bestCol = k;
                }
            }
            if (bestCol < 0) {
                throw new RuntimeException();
            }
            int n = bestCol;
            this.ipiv[n] = this.ipiv[n] + 1;
            if (bestRow != bestCol) {
                GaussJordan.swapRow(A, A.numCols, bestRow, bestCol);
            }
            this.indexRow[i] = bestRow;
            this.indexCol[i] = bestCol;
            double valA = A.get(bestCol, bestCol);
            if (valA == 0.0) {
                throw new SingularMatrixException();
            }
            A.set(bestCol * N + bestCol, 1.0);
            for (int x = 0; x < N; ++x) {
                A.div(bestCol * N + x, valA);
            }
            for (int j = 0; j < N; ++j) {
                if (bestCol == j) continue;
                double val = A.get(j, bestCol);
                A.set(j * N + bestCol, 0.0);
                for (int x = 0; x < N; ++x) {
                    A.minus(j * N + x, val * A.get(bestCol * N + x));
                }
            }
        }
        GaussJordan.unscramble(N, A, this.indexRow, this.indexCol);
    }

    @Override
    public void solve(DenseMatrix64F B, DenseMatrix64F X) {
        int i;
        GaussJordan.checkArgumentSquare(this.A, "A");
        if (this.A.getNumCols() != B.getNumRows()) {
            throw new IllegalArgumentException("Dimensions of A and B are not compatible.");
        }
        X.set(B);
        int N = this.A.numCols;
        for (i = 0; i < N; ++i) {
            this.ipiv[i] = 0;
        }
        for (i = 0; i < N; ++i) {
            int x;
            double bestVal = 0.0;
            int bestRow = -1;
            int bestCol = -1;
            for (int j = 0; j < N; ++j) {
                if (this.ipiv[j] == 1) continue;
                for (int k = 0; k < N; ++k) {
                    if (this.ipiv[k] != 0) continue;
                    double val = this.A.unsafe_get(j, k);
                    if (val < 0.0) {
                        val = -val;
                    }
                    if (!(val > bestVal)) continue;
                    bestVal = val;
                    bestRow = j;
                    bestCol = k;
                }
            }
            int n = bestCol;
            this.ipiv[n] = this.ipiv[n] + 1;
            if (bestRow != bestCol) {
                GaussJordan.swapRow(this.A, this.A.numCols, bestRow, bestCol);
                GaussJordan.swapRow(X, X.numCols, bestRow, bestCol);
            }
            this.indexRow[i] = bestRow;
            this.indexCol[i] = bestCol;
            double valA = this.A.get(bestCol, bestCol);
            if (valA == 0.0) {
                throw new RuntimeException("Singular Matrix");
            }
            valA = 1.0 / valA;
            this.A.unsafe_set(bestCol, bestCol, 1.0);
            for (x = 0; x < N; ++x) {
                this.A.times(bestCol * N + x, valA);
            }
            for (x = 0; x < X.numCols; ++x) {
                X.times(bestCol * X.numCols + x, valA);
            }
            for (int j = 0; j < N; ++j) {
                int x2;
                if (bestCol == j) continue;
                double val = this.A.get(j, bestCol);
                this.A.set(j * N + bestCol, 0.0);
                for (x2 = 0; x2 < N; ++x2) {
                    this.A.minus(j * N + x2, val * this.A.get(bestCol * N + x2));
                }
                for (x2 = 0; x2 < X.numCols; ++x2) {
                    X.minus(j * X.numCols + x2, val * X.get(bestCol * X.numCols + x2));
                }
            }
        }
        GaussJordan.unscramble(N, this.A, this.indexRow, this.indexCol);
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    private static void unscramble(int N, RowD1Matrix64F data, int[] indexRow, int[] indexCol) {
        for (int i = N - 1; i >= 0; --i) {
            if (indexRow[i] == indexCol[i]) continue;
            for (int k = 0; k < N; ++k) {
                int row = k * N;
                int ir = row + indexRow[i];
                int ic = row + indexCol[i];
                double temp = data.get(ir);
                data.set(ir, data.get(ic));
                data.set(ic, temp);
            }
        }
    }

    private static void swapRow(RowD1Matrix64F data, int numCols, int fromRow, int toRow) {
        int indexFrom = fromRow * numCols;
        int indexTo = toRow * numCols;
        int end = indexFrom + numCols;
        while (indexFrom < end) {
            double temp = data.get(indexTo);
            data.set(indexTo, data.get(indexFrom));
            data.set(indexFrom, temp);
            ++indexFrom;
            ++indexTo;
        }
    }
}

