/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.render;

import com.google.common.collect.Lists;
import com.google.visualization.datasource.base.DataSourceParameters;
import com.google.visualization.datasource.base.ReasonType;
import com.google.visualization.datasource.base.ResponseStatus;
import com.google.visualization.datasource.base.StatusType;
import com.google.visualization.datasource.base.Warning;
import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableCell;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.value.BooleanValue;
import com.google.visualization.datasource.datatable.value.DateTimeValue;
import com.google.visualization.datasource.datatable.value.DateValue;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.TimeOfDayValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.render.EscapeUtil;
import com.ibm.icu.util.GregorianCalendar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;

public class JsonRenderer {
    private JsonRenderer() {
    }

    public static String getSignature(DataTable data) {
        String tableAsString = ((Object)JsonRenderer.renderDataTable(data, true, false)).toString();
        long longHashCode = tableAsString.hashCode();
        return String.valueOf(Math.abs(longHashCode));
    }

    private static String getFaultString(ReasonType reasonType, String description) {
        ArrayList objectParts = Lists.newArrayList();
        if (reasonType != null) {
            objectParts.add("reason:'" + reasonType.lowerCaseString() + "'");
            objectParts.add("message:'" + EscapeUtil.jsonEscape(reasonType.getMessageForReasonType(null)) + "'");
        }
        if (description != null) {
            objectParts.add("detailed_message:'" + EscapeUtil.jsonEscape(description) + "'");
        }
        return new StrBuilder("{").appendWithSeparators((Collection)objectParts, ",").append("}").toString();
    }

    public static CharSequence renderJsonResponse(DataSourceParameters dsParams, ResponseStatus responseStatus, DataTable data, boolean isJsonp) {
        StrBuilder sb = new StrBuilder();
        if (isJsonp) {
            sb.append(dsParams.getResponseHandler()).append("(");
        }
        sb.append("{version:'0.6'");
        String requestId = dsParams.getRequestId();
        if (requestId != null) {
            sb.append(",reqId:'").append(EscapeUtil.jsonEscape(requestId)).append("'");
        }
        String previousSignature = dsParams.getSignature();
        if (responseStatus == null) {
            responseStatus = !StringUtils.isEmpty((String)previousSignature) && data != null && JsonRenderer.getSignature(data).equals(previousSignature) ? new ResponseStatus(StatusType.ERROR, ReasonType.NOT_MODIFIED, null) : new ResponseStatus(StatusType.OK, null, null);
        }
        StatusType statusType = responseStatus.getStatusType();
        sb.append(",status:'").append(statusType.lowerCaseString()).append("'");
        if (statusType != StatusType.OK) {
            if (statusType == StatusType.WARNING) {
                List<Warning> warnings = data.getWarnings();
                ArrayList warningJsonStrings = Lists.newArrayList();
                if (warnings != null) {
                    for (Warning warning : warnings) {
                        warningJsonStrings.add(JsonRenderer.getFaultString(warning.getReasonType(), warning.getMessage()));
                    }
                }
                sb.append(",warnings:[").appendWithSeparators((Collection)warningJsonStrings, ",").append("]");
            } else {
                sb.append(",errors:[");
                sb.append(JsonRenderer.getFaultString(responseStatus.getReasonType(), responseStatus.getDescription()));
                sb.append("]");
            }
        }
        if (statusType != StatusType.ERROR && data != null) {
            sb.append(",sig:'").append(JsonRenderer.getSignature(data)).append("'");
            sb.append(",table:").append((Object)JsonRenderer.renderDataTable(data, true, true));
        }
        sb.append("}");
        if (isJsonp) {
            sb.append(");");
        }
        return sb.toString();
    }

    public static CharSequence renderDataTable(DataTable dataTable, boolean includeValues, boolean includeFormatting) {
        String customPropertiesString;
        if (dataTable.getColumnDescriptions().isEmpty()) {
            return "";
        }
        List<ColumnDescription> columnDescriptions = dataTable.getColumnDescriptions();
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("cols:[");
        for (int colId = 0; colId < columnDescriptions.size(); ++colId) {
            ColumnDescription col = columnDescriptions.get(colId);
            JsonRenderer.appendColumnDescriptionJson(col, sb);
            if (colId == columnDescriptions.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        if (includeValues) {
            sb.append(",rows:[");
            List<TableRow> rows = dataTable.getRows();
            for (int rowId = 0; rowId < rows.size(); ++rowId) {
                TableRow tableRow = rows.get(rowId);
                List<TableCell> cells = tableRow.getCells();
                sb.append("{c:[");
                for (int cellId = 0; cellId < cells.size(); ++cellId) {
                    TableCell cell = cells.get(cellId);
                    if (cellId < cells.size() - 1) {
                        JsonRenderer.appendCellJson(cell, sb, includeFormatting, false);
                        sb.append(",");
                        continue;
                    }
                    JsonRenderer.appendCellJson(cell, sb, includeFormatting, true);
                }
                sb.append("]");
                String customPropertiesString2 = JsonRenderer.getPropertiesMapString(tableRow.getCustomProperties());
                if (customPropertiesString2 != null) {
                    sb.append(",p:").append(customPropertiesString2);
                }
                sb.append("}");
                if (rows.size() - 1 <= rowId) continue;
                sb.append(",");
            }
            sb.append("]");
        }
        if ((customPropertiesString = JsonRenderer.getPropertiesMapString(dataTable.getCustomProperties())) != null) {
            sb.append(",p:").append(customPropertiesString);
        }
        sb.append("}");
        return sb;
    }

    public static StringBuilder appendCellJson(TableCell cell, StringBuilder sb, boolean includeFormatting, boolean isLastColumn) {
        Value value = cell.getValue();
        ValueType type = cell.getType();
        StringBuilder valueJson = new StringBuilder();
        String escapedFormattedString = "";
        boolean isJsonNull = false;
        if (value == null || value.isNull()) {
            valueJson.append("null");
            isJsonNull = true;
        } else {
            switch (type) {
                case BOOLEAN: {
                    valueJson.append(((BooleanValue)value).getValue());
                    break;
                }
                case DATE: {
                    valueJson.append("new Date(");
                    DateValue dateValue = (DateValue)value;
                    valueJson.append(dateValue.getYear()).append(",");
                    valueJson.append(dateValue.getMonth()).append(",");
                    valueJson.append(dateValue.getDayOfMonth());
                    valueJson.append(")");
                    break;
                }
                case NUMBER: {
                    valueJson.append(((NumberValue)value).getValue());
                    break;
                }
                case TEXT: {
                    valueJson.append("'");
                    valueJson.append(EscapeUtil.jsonEscape(value.toString()));
                    valueJson.append("'");
                    break;
                }
                case TIMEOFDAY: {
                    valueJson.append("[");
                    TimeOfDayValue timeOfDayValue = (TimeOfDayValue)value;
                    valueJson.append(timeOfDayValue.getHours()).append(",");
                    valueJson.append(timeOfDayValue.getMinutes()).append(",");
                    valueJson.append(timeOfDayValue.getSeconds()).append(",");
                    valueJson.append(timeOfDayValue.getMilliseconds());
                    valueJson.append("]");
                    break;
                }
                case DATETIME: {
                    GregorianCalendar calendar = ((DateTimeValue)value).getCalendar();
                    valueJson.append("new Date(");
                    valueJson.append(calendar.get(1)).append(",");
                    valueJson.append(calendar.get(2)).append(",");
                    valueJson.append(calendar.get(5));
                    valueJson.append(",");
                    valueJson.append(calendar.get(11));
                    valueJson.append(",");
                    valueJson.append(calendar.get(12)).append(",");
                    valueJson.append(calendar.get(13));
                    valueJson.append(")");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal value Type " + (Object)((Object)type));
                }
            }
        }
        String formattedValue = cell.getFormattedValue();
        if (value != null && !value.isNull() && formattedValue != null) {
            escapedFormattedString = EscapeUtil.jsonEscape(formattedValue);
            if (type == ValueType.TEXT && value.toString().equals(formattedValue)) {
                escapedFormattedString = "";
            }
        }
        if (isLastColumn || !isJsonNull) {
            String customPropertiesString;
            sb.append("{");
            sb.append("v:").append((CharSequence)valueJson);
            if (includeFormatting && !escapedFormattedString.equals("")) {
                sb.append(",f:'").append(escapedFormattedString).append("'");
            }
            if ((customPropertiesString = JsonRenderer.getPropertiesMapString(cell.getCustomProperties())) != null) {
                sb.append(",p:").append(customPropertiesString);
            }
            sb.append("}");
        }
        return sb;
    }

    public static StringBuilder appendColumnDescriptionJson(ColumnDescription col, StringBuilder sb) {
        sb.append("{");
        sb.append("id:'").append(EscapeUtil.jsonEscape(col.getId())).append("',");
        sb.append("label:'").append(EscapeUtil.jsonEscape(col.getLabel())).append("',");
        sb.append("type:'").append(col.getType().getTypeCodeLowerCase()).append("',");
        sb.append("pattern:'").append(EscapeUtil.jsonEscape(col.getPattern())).append("'");
        String customPropertiesString = JsonRenderer.getPropertiesMapString(col.getCustomProperties());
        if (customPropertiesString != null) {
            sb.append(",p:").append(customPropertiesString);
        }
        sb.append("}");
        return sb;
    }

    private static String getPropertiesMapString(Map<String, String> propertiesMap) {
        String customPropertiesString = null;
        if (propertiesMap != null && !propertiesMap.isEmpty()) {
            ArrayList customPropertiesStrings = Lists.newArrayList();
            for (Map.Entry<String, String> entry : propertiesMap.entrySet()) {
                customPropertiesStrings.add("'" + EscapeUtil.jsonEscape(entry.getKey()) + "':'" + EscapeUtil.jsonEscape(entry.getValue()) + "'");
            }
            customPropertiesString = new StrBuilder("{").appendWithSeparators((Collection)customPropertiesStrings, ",").append("}").toString();
        }
        return customPropertiesString;
    }
}

