/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.render;

import com.google.visualization.datasource.base.ResponseStatus;
import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableCell;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.ValueFormatter;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.ibm.icu.util.ULocale;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CsvRenderer {
    private CsvRenderer() {
    }

    public static CharSequence renderDataTable(DataTable dataTable, ULocale locale, String separator) {
        if (separator == null) {
            separator = ",";
        }
        if (dataTable.getColumnDescriptions().isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List<ColumnDescription> columns = dataTable.getColumnDescriptions();
        for (ColumnDescription column : columns) {
            sb.append(CsvRenderer.escapeString(column.getLabel())).append(separator);
        }
        Map<ValueType, ValueFormatter> formatters = ValueFormatter.createDefaultFormatters(locale);
        int length = sb.length();
        sb.replace(length - 1, length, "\n");
        List<TableRow> rows = dataTable.getRows();
        for (TableRow row : rows) {
            List<TableCell> cells = row.getCells();
            for (TableCell cell : cells) {
                String formattedValue = cell.getFormattedValue();
                if (formattedValue == null) {
                    formattedValue = formatters.get((Object)cell.getType()).format(cell.getValue());
                }
                if (cell.isNull()) {
                    sb.append("null");
                } else {
                    ValueType type = cell.getType();
                    if (formattedValue.indexOf(44) > -1 || type.equals((Object)ValueType.TEXT)) {
                        sb.append(CsvRenderer.escapeString(formattedValue));
                    } else {
                        sb.append(formattedValue);
                    }
                }
                sb.append(separator);
            }
            length = sb.length();
            sb.replace(length - 1, length, "\n");
        }
        return sb.toString();
    }

    private static String escapeString(String input) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        sb.append(StringUtils.replace((String)input, (String)"\"", (String)"\"\""));
        sb.append("\"");
        return sb.toString();
    }

    public static String renderCsvError(ResponseStatus responseStatus) {
        StringBuilder sb = new StringBuilder();
        sb.append("Error: ").append(responseStatus.getReasonType().getMessageForReasonType(null));
        sb.append(". ").append(responseStatus.getDescription());
        return CsvRenderer.escapeString(sb.toString());
    }
}

