/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.scalarfunction;

import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.datatable.value.TextValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.scalarfunction.ScalarFunction;
import java.util.List;

public class Upper
implements ScalarFunction {
    private static final String FUNCTION_NAME = "upper";
    private static final Upper INSTANCE = new Upper();

    private Upper() {
    }

    public static Upper getInstance() {
        return INSTANCE;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    public Value evaluate(List<Value> values) {
        return new TextValue(((TextValue)values.get(0)).getValue().toUpperCase());
    }

    @Override
    public ValueType getReturnType(List<ValueType> types) {
        return ValueType.TEXT;
    }

    @Override
    public void validateParameters(List<ValueType> types) throws InvalidQueryException {
        if (types.size() != 1) {
            throw new InvalidQueryException("upper requires 1 parmaeter");
        }
        if (types.get(0) != ValueType.TEXT) {
            throw new InvalidQueryException("upper takes a text parameter");
        }
    }

    @Override
    public String toQueryString(List<String> argumentsQueryStrings) {
        return "upper(" + argumentsQueryStrings.get(0) + ")";
    }
}

