/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.scalarfunction;

import com.google.common.collect.Maps;
import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.datatable.value.DateTimeValue;
import com.google.visualization.datasource.datatable.value.DateValue;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.TimeOfDayValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.scalarfunction.ScalarFunction;
import com.ibm.icu.util.GregorianCalendar;
import java.util.List;
import java.util.Map;

public class TimeComponentExtractor
implements ScalarFunction {
    private static Map<TimeComponent, TimeComponentExtractor> timeComponentsPool = Maps.newHashMap();
    private TimeComponent timeComponent;

    public static TimeComponentExtractor getInstance(TimeComponent timeComponent) {
        return timeComponentsPool.get((Object)timeComponent);
    }

    private TimeComponentExtractor(TimeComponent timeComponent) {
        this.timeComponent = timeComponent;
    }

    @Override
    public String getFunctionName() {
        return this.timeComponent.getName();
    }

    @Override
    public Value evaluate(List<Value> values) {
        int component;
        Value value = values.get(0);
        ValueType valueType = value.getType();
        if (value.isNull()) {
            return NumberValue.getNullValue();
        }
        switch (this.timeComponent) {
            case YEAR: {
                if (valueType == ValueType.DATE) {
                    component = ((DateValue)value).getYear();
                    break;
                }
                component = ((DateTimeValue)value).getYear();
                break;
            }
            case MONTH: {
                if (valueType == ValueType.DATE) {
                    component = ((DateValue)value).getMonth();
                    break;
                }
                component = ((DateTimeValue)value).getMonth();
                break;
            }
            case DAY: {
                if (valueType == ValueType.DATE) {
                    component = ((DateValue)value).getDayOfMonth();
                    break;
                }
                component = ((DateTimeValue)value).getDayOfMonth();
                break;
            }
            case HOUR: {
                if (valueType == ValueType.TIMEOFDAY) {
                    component = ((TimeOfDayValue)value).getHours();
                    break;
                }
                component = ((DateTimeValue)value).getHourOfDay();
                break;
            }
            case MINUTE: {
                if (valueType == ValueType.TIMEOFDAY) {
                    component = ((TimeOfDayValue)value).getMinutes();
                    break;
                }
                component = ((DateTimeValue)value).getMinute();
                break;
            }
            case SECOND: {
                if (valueType == ValueType.TIMEOFDAY) {
                    component = ((TimeOfDayValue)value).getSeconds();
                    break;
                }
                component = ((DateTimeValue)value).getSecond();
                break;
            }
            case MILLISECOND: {
                if (valueType == ValueType.TIMEOFDAY) {
                    component = ((TimeOfDayValue)value).getMilliseconds();
                    break;
                }
                component = ((DateTimeValue)value).getMillisecond();
                break;
            }
            case QUARTER: {
                component = valueType == ValueType.DATE ? ((DateValue)value).getMonth() : ((DateTimeValue)value).getMonth();
                component = component / 3 + 1;
                break;
            }
            case DAY_OF_WEEK: {
                GregorianCalendar calendar = (GregorianCalendar)(valueType == ValueType.DATE ? ((DateValue)value).getObjectToFormat() : ((DateTimeValue)value).getObjectToFormat());
                component = calendar.get(7);
                break;
            }
            default: {
                throw new RuntimeException("An invalid time component.");
            }
        }
        return new NumberValue(component);
    }

    @Override
    public ValueType getReturnType(List<ValueType> types) {
        return ValueType.NUMBER;
    }

    @Override
    public void validateParameters(List<ValueType> types) throws InvalidQueryException {
        if (types.size() != 1) {
            throw new InvalidQueryException("Number of parameters for " + this.timeComponent.getName() + "function is wrong: " + types.size());
        }
        switch (this.timeComponent) {
            case YEAR: 
            case MONTH: 
            case DAY: 
            case QUARTER: 
            case DAY_OF_WEEK: {
                if (types.get(0) == ValueType.DATE || types.get(0) == ValueType.DATETIME) break;
                throw new InvalidQueryException("Can't perform the function " + this.timeComponent.getName() + " on a column that is not a Date or" + " a DateTime column");
            }
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case MILLISECOND: {
                if (types.get(0) == ValueType.TIMEOFDAY || types.get(0) == ValueType.DATETIME) break;
                throw new InvalidQueryException("Can't perform the function " + this.timeComponent.getName() + " on a column that is not a " + "TimeOfDay or a DateTime column");
            }
        }
    }

    public boolean equals(Object o) {
        if (o instanceof TimeComponentExtractor) {
            TimeComponentExtractor other = (TimeComponentExtractor)o;
            return this.timeComponent.equals((Object)other.timeComponent);
        }
        return false;
    }

    public int hashCode() {
        return this.timeComponent == null ? 0 : this.timeComponent.hashCode();
    }

    @Override
    public String toQueryString(List<String> argumentsQueryStrings) {
        return this.getFunctionName() + "(" + argumentsQueryStrings.get(0) + ")";
    }

    static {
        for (TimeComponent component : TimeComponent.values()) {
            timeComponentsPool.put(component, new TimeComponentExtractor(component));
        }
    }

    public static enum TimeComponent {
        YEAR("year"),
        MONTH("month"),
        WEEK("week"),
        DAY("day"),
        HOUR("hour"),
        MINUTE("minute"),
        SECOND("second"),
        MILLISECOND("millisecond"),
        QUARTER("quarter"),
        DAY_OF_WEEK("dayofweek");

        private String name;

        private TimeComponent(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

