/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.scalarfunction;

import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.scalarfunction.ScalarFunction;
import java.util.List;

public class Sum
implements ScalarFunction {
    private static final String FUNCTION_NAME = "sum";
    private static final Sum INSTANCE = new Sum();

    private Sum() {
    }

    public static Sum getInstance() {
        return INSTANCE;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    public Value evaluate(List<Value> values) {
        if (values.get(0).isNull() || values.get(1).isNull()) {
            return NumberValue.getNullValue();
        }
        double sum = ((NumberValue)values.get(0)).getValue() + ((NumberValue)values.get(1)).getValue();
        return new NumberValue(sum);
    }

    @Override
    public ValueType getReturnType(List<ValueType> types) {
        return ValueType.NUMBER;
    }

    @Override
    public void validateParameters(List<ValueType> types) throws InvalidQueryException {
        if (types.size() != 2) {
            throw new InvalidQueryException("The function sum requires 2 parmaeters ");
        }
        for (ValueType type : types) {
            if (type == ValueType.NUMBER) continue;
            throw new InvalidQueryException("Can't perform the function sum on values that are not numbers");
        }
    }

    @Override
    public String toQueryString(List<String> argumentsQueryStrings) {
        return "(" + argumentsQueryStrings.get(0) + " + " + argumentsQueryStrings.get(1) + ")";
    }
}

