/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.scalarfunction;

import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.scalarfunction.ScalarFunction;
import java.util.List;

public class Constant
implements ScalarFunction {
    private Value value;

    public Constant(Value value) {
        this.value = value;
    }

    @Override
    public String getFunctionName() {
        return this.value.toQueryString();
    }

    @Override
    public Value evaluate(List<Value> values) {
        return this.value;
    }

    @Override
    public ValueType getReturnType(List<ValueType> types) {
        return this.value.getType();
    }

    @Override
    public void validateParameters(List<ValueType> types) throws InvalidQueryException {
        if (types.size() != 0) {
            throw new InvalidQueryException("The constant function should not get any parameters");
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Constant) {
            Constant other = (Constant)o;
            return this.value.equals(other.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    @Override
    public String toQueryString(List<String> argumentsQueryStrings) {
        return this.value.toQueryString();
    }
}

