/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.engine;

import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.ColumnLookup;
import com.google.visualization.datasource.query.ColumnSort;
import com.google.visualization.datasource.query.QuerySort;
import com.google.visualization.datasource.query.SortOrder;
import com.ibm.icu.util.ULocale;
import java.util.Comparator;
import java.util.List;

class TableRowComparator
implements Comparator<TableRow> {
    private AbstractColumn[] sortColumns;
    private SortOrder[] sortColumnOrder;
    private Comparator<Value> valueComparator;
    private ColumnLookup columnLookup;

    public TableRowComparator(QuerySort sort, ULocale locale, ColumnLookup lookup) {
        this.valueComparator = Value.getLocalizedComparator(locale);
        this.columnLookup = lookup;
        List<ColumnSort> columns = sort.getSortColumns();
        this.sortColumns = new AbstractColumn[columns.size()];
        this.sortColumnOrder = new SortOrder[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            ColumnSort columnSort = columns.get(i);
            this.sortColumns[i] = columnSort.getColumn();
            this.sortColumnOrder[i] = columnSort.getOrder();
        }
    }

    @Override
    public int compare(TableRow r1, TableRow r2) {
        for (int i = 0; i < this.sortColumns.length; ++i) {
            AbstractColumn col = this.sortColumns[i];
            int cc = this.valueComparator.compare(col.getValue(this.columnLookup, r1), col.getValue(this.columnLookup, r2));
            if (cc == 0) continue;
            return this.sortColumnOrder[i] == SortOrder.ASCENDING ? cc : -cc;
        }
        return 0;
    }
}

