/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.engine;

import com.google.common.collect.Sets;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.query.engine.AggregationNode;
import com.google.visualization.datasource.query.engine.AggregationPath;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AggregationTree {
    private AggregationNode root;
    private Set<String> columnsToAggregate;
    private DataTable table;

    public AggregationTree(Set<String> columnsToAggregate, DataTable table) {
        this.columnsToAggregate = columnsToAggregate;
        this.table = table;
        this.root = new AggregationNode(columnsToAggregate, table);
    }

    public void aggregate(AggregationPath path, Map<String, Value> valuesToAggregate) {
        AggregationNode curNode = this.root;
        this.root.aggregate(valuesToAggregate);
        for (Value curValue : path.getValues()) {
            if (!curNode.containsChild(curValue)) {
                curNode.addChild(curValue, this.columnsToAggregate, this.table);
            }
            curNode = curNode.getChild(curValue);
            curNode.aggregate(valuesToAggregate);
        }
    }

    public AggregationNode getNode(AggregationPath path) {
        AggregationNode curNode = this.root;
        for (Value curValue : path.getValues()) {
            curNode = curNode.getChild(curValue);
        }
        return curNode;
    }

    public Set<AggregationPath> getPathsToLeaves() {
        HashSet result = Sets.newHashSet();
        this.getPathsToLeavesInternal(this.root, result);
        return result;
    }

    private void getPathsToLeavesInternal(AggregationNode node, Set<AggregationPath> result) {
        Map<Value, AggregationNode> children = node.getChildren();
        if (children.isEmpty()) {
            result.add(AggregationTree.getPathToNode(node));
        } else {
            for (AggregationNode curNode : children.values()) {
                this.getPathsToLeavesInternal(curNode, result);
            }
        }
    }

    private static final AggregationPath getPathToNode(AggregationNode node) {
        AggregationPath result = new AggregationPath();
        AggregationNode curNode = node;
        while (curNode.getValue() != null) {
            result.add(curNode.getValue());
            curNode = curNode.getParent();
        }
        result.reverse();
        return result;
    }
}

