/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.Lists;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import java.util.List;

public class SimpleColumn
extends AbstractColumn {
    private String columnId;

    public SimpleColumn(String columnId) {
        this.columnId = columnId;
    }

    public String getColumnId() {
        return this.columnId;
    }

    @Override
    public String getId() {
        return this.columnId;
    }

    @Override
    public List<String> getAllSimpleColumnIds() {
        return Lists.newArrayList((Object[])new String[]{this.columnId});
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof SimpleColumn) {
            SimpleColumn other = (SimpleColumn)o;
            return this.columnId.equals(other.columnId);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 1279;
        hash = hash * 17 + this.columnId.hashCode();
        return hash;
    }

    public String toString() {
        return this.columnId;
    }

    @Override
    public List<SimpleColumn> getAllSimpleColumns() {
        return Lists.newArrayList((Object[])new SimpleColumn[]{this});
    }

    @Override
    public List<AggregationColumn> getAllAggregationColumns() {
        return Lists.newArrayList();
    }

    @Override
    public List<ScalarFunctionColumn> getAllScalarFunctionColumns() {
        return Lists.newArrayList();
    }

    @Override
    public void validateColumn(DataTable dataTable) {
    }

    @Override
    public ValueType getValueType(DataTable dataTable) {
        return dataTable.getColumnDescription(this.columnId).getType();
    }

    @Override
    public String toQueryString() {
        if (this.columnId.contains("`")) {
            throw new RuntimeException("Column ID cannot contain backtick (`)");
        }
        return "`" + this.columnId + "`";
    }
}

