/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.Query;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import com.google.visualization.datasource.query.SimpleColumn;
import java.util.ArrayList;
import java.util.List;

public class QuerySelection {
    private List<AbstractColumn> columns;

    public QuerySelection() {
        this.columns = Lists.newArrayList();
    }

    public QuerySelection(QuerySelection source) {
        this.columns = Lists.newArrayList(source.columns);
    }

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public void addColumn(AbstractColumn column) {
        this.columns.add(column);
    }

    public List<AbstractColumn> getColumns() {
        return ImmutableList.copyOf(this.columns);
    }

    public List<AggregationColumn> getAggregationColumns() {
        ArrayList result = Lists.newArrayList();
        for (AbstractColumn col : this.columns) {
            result.addAll(col.getAllAggregationColumns());
        }
        return result;
    }

    public List<SimpleColumn> getSimpleColumns() {
        ArrayList result = Lists.newArrayList();
        for (AbstractColumn col : this.columns) {
            result.addAll(col.getAllSimpleColumns());
        }
        return result;
    }

    public List<ScalarFunctionColumn> getScalarFunctionColumns() {
        ArrayList result = Lists.newArrayList();
        for (AbstractColumn col : this.columns) {
            result.addAll(col.getAllScalarFunctionColumns());
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columns == null ? 0 : ((Object)this.columns).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuerySelection other = (QuerySelection)obj;
        return !(this.columns == null ? other.columns != null : !((Object)this.columns).equals(other.columns));
    }

    public String toQueryString() {
        return Query.columnListToQueryString(this.columns);
    }
}

