/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.Query;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryLabels {
    private static final Log log = LogFactory.getLog((String)QueryLabels.class.getName());
    private Map<AbstractColumn, String> columnLabels = Maps.newHashMap();

    public void addLabel(AbstractColumn column, String label) throws InvalidQueryException {
        if (this.columnLabels.keySet().contains(column)) {
            String messageToLogAndUser = "Column [" + column.toString() + "] is " + "specified more than once in LABEL.";
            log.error((Object)messageToLogAndUser);
            throw new InvalidQueryException(messageToLogAndUser);
        }
        this.columnLabels.put(column, label);
    }

    public String getLabel(AbstractColumn column) {
        return this.columnLabels.get(column);
    }

    public Set<AbstractColumn> getColumns() {
        return ImmutableSet.copyOf(this.columnLabels.keySet());
    }

    public List<ScalarFunctionColumn> getScalarFunctionColumns() {
        ArrayList result = Lists.newArrayList();
        for (AbstractColumn col : this.columnLabels.keySet()) {
            for (ScalarFunctionColumn innerCol : col.getAllScalarFunctionColumns()) {
                if (result.contains(innerCol)) continue;
                result.add(innerCol);
            }
        }
        return result;
    }

    public List<AggregationColumn> getAggregationColumns() {
        ArrayList result = Lists.newArrayList();
        for (AbstractColumn col : this.columnLabels.keySet()) {
            result.addAll(col.getAllAggregationColumns());
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnLabels == null ? 0 : ((Object)this.columnLabels).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryLabels other = (QueryLabels)obj;
        return !(this.columnLabels == null ? other.columnLabels != null : !((Object)this.columnLabels).equals(other.columnLabels));
    }

    public String toQueryString() {
        StrBuilder builder = new StrBuilder();
        ArrayList stringList = Lists.newArrayList();
        for (AbstractColumn col : this.columnLabels.keySet()) {
            String label = this.columnLabels.get(col);
            stringList.add(col.toQueryString() + " " + Query.stringToQueryStringLiteral(label));
        }
        builder.appendWithSeparators((Collection)stringList, ", ");
        return builder.toString();
    }
}

