/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.Query;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import com.google.visualization.datasource.query.SimpleColumn;
import java.util.ArrayList;
import java.util.List;

public class QueryGroup {
    private List<AbstractColumn> columns = Lists.newArrayList();

    public void addColumn(AbstractColumn column) {
        this.columns.add(column);
    }

    public List<String> getColumnIds() {
        ArrayList columnIds = Lists.newArrayList();
        for (AbstractColumn col : this.columns) {
            columnIds.add(col.getId());
        }
        return ImmutableList.copyOf((Iterable)columnIds);
    }

    public List<String> getSimpleColumnIds() {
        ArrayList columnIds = Lists.newArrayList();
        for (AbstractColumn col : this.columns) {
            columnIds.addAll(col.getAllSimpleColumnIds());
        }
        return columnIds;
    }

    public List<AbstractColumn> getColumns() {
        return ImmutableList.copyOf(this.columns);
    }

    public List<SimpleColumn> getSimpleColumns() {
        ArrayList simpleColumns = Lists.newArrayList();
        for (AbstractColumn col : this.columns) {
            simpleColumns.addAll(col.getAllSimpleColumns());
        }
        return simpleColumns;
    }

    public List<ScalarFunctionColumn> getScalarFunctionColumns() {
        ArrayList scalarFunctionColumns = Lists.newArrayList();
        for (AbstractColumn col : this.columns) {
            scalarFunctionColumns.addAll(col.getAllScalarFunctionColumns());
        }
        return scalarFunctionColumns;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columns == null ? 0 : ((Object)this.columns).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryGroup other = (QueryGroup)obj;
        return !(this.columns == null ? other.columns != null : !((Object)this.columns).equals(other.columns));
    }

    public String toQueryString() {
        return Query.columnListToQueryString(this.columns);
    }
}

