/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.QueryFilter;
import com.google.visualization.datasource.query.QueryFormat;
import com.google.visualization.datasource.query.QueryGroup;
import com.google.visualization.datasource.query.QueryLabels;
import com.google.visualization.datasource.query.QueryOptions;
import com.google.visualization.datasource.query.QueryPivot;
import com.google.visualization.datasource.query.QuerySelection;
import com.google.visualization.datasource.query.QuerySort;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import com.google.visualization.datasource.query.SimpleColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Query {
    private static final Log log = LogFactory.getLog((String)Query.class.getName());
    private QuerySort sort = null;
    protected QuerySelection selection = null;
    private QueryFilter filter = null;
    private QueryGroup group = null;
    private QueryPivot pivot = null;
    private int rowLimit = -1;
    private int rowOffset = 0;
    private QueryOptions options = null;
    private QueryLabels labels = null;
    private QueryFormat userFormatOptions = null;

    private static <T> void checkForDuplicates(List<T> selectionColumns, String clauseName) throws InvalidQueryException {
        for (int i = 0; i < selectionColumns.size(); ++i) {
            T col = selectionColumns.get(i);
            for (int j = i + 1; j < selectionColumns.size(); ++j) {
                if (!col.equals(selectionColumns.get(j))) continue;
                String messageToLogAndUser = "Column [" + col.toString() + "] " + "cannot appear more than once in " + clauseName + ".";
                log.error((Object)messageToLogAndUser);
                throw new InvalidQueryException(messageToLogAndUser);
            }
        }
    }

    public void setSort(QuerySort sort) {
        this.sort = sort;
    }

    public QuerySort getSort() {
        return this.sort;
    }

    public boolean hasSort() {
        return this.sort != null && !this.sort.isEmpty();
    }

    public void setSelection(QuerySelection selection) {
        this.selection = selection;
    }

    public QuerySelection getSelection() {
        return this.selection;
    }

    public boolean hasSelection() {
        return this.selection != null && !this.selection.isEmpty();
    }

    public void setFilter(QueryFilter filter) {
        this.filter = filter;
    }

    public QueryFilter getFilter() {
        return this.filter;
    }

    public boolean hasFilter() {
        return this.filter != null;
    }

    public void setGroup(QueryGroup group) {
        this.group = group;
    }

    public void setPivot(QueryPivot pivot) {
        this.pivot = pivot;
    }

    public QueryGroup getGroup() {
        return this.group;
    }

    public boolean hasGroup() {
        return this.group != null && !this.group.getColumnIds().isEmpty();
    }

    public QueryPivot getPivot() {
        return this.pivot;
    }

    public boolean hasPivot() {
        return this.pivot != null && !this.pivot.getColumnIds().isEmpty();
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) throws InvalidQueryException {
        if (rowLimit < -1) {
            String messageToLogAndUser = "Invalid value for row limit: " + rowLimit;
            log.error((Object)messageToLogAndUser);
            throw new InvalidQueryException(messageToLogAndUser);
        }
        this.rowLimit = rowLimit;
    }

    public void copyRowLimit(Query originalQuery) {
        this.rowLimit = originalQuery.getRowLimit();
    }

    public boolean hasRowLimit() {
        return this.rowLimit > -1;
    }

    public int getRowOffset() {
        return this.rowOffset;
    }

    public void setRowOffset(int rowOffset) throws InvalidQueryException {
        if (rowOffset < 0) {
            String messageToLogAndUser = "Invalid value for row offset: " + rowOffset;
            log.error((Object)messageToLogAndUser);
            throw new InvalidQueryException(messageToLogAndUser);
        }
        this.rowOffset = rowOffset;
    }

    public void copyRowOffset(Query originalQuery) {
        this.rowOffset = originalQuery.getRowOffset();
    }

    public boolean hasRowOffset() {
        return this.rowOffset > 0;
    }

    public QueryFormat getUserFormatOptions() {
        return this.userFormatOptions;
    }

    public void setUserFormatOptions(QueryFormat userFormatOptions) {
        this.userFormatOptions = userFormatOptions;
    }

    public boolean hasUserFormatOptions() {
        return this.userFormatOptions != null && !this.userFormatOptions.getColumns().isEmpty();
    }

    public QueryLabels getLabels() {
        return this.labels;
    }

    public void setLabels(QueryLabels labels) {
        this.labels = labels;
    }

    public boolean hasLabels() {
        return this.labels != null && !this.labels.getColumns().isEmpty();
    }

    public QueryOptions getOptions() {
        return this.options;
    }

    public void setOptions(QueryOptions options) {
        this.options = options;
    }

    public boolean hasOptions() {
        return this.options != null && !this.options.isDefault();
    }

    public boolean isEmpty() {
        return !this.hasSort() && !this.hasSelection() && !this.hasFilter() && !this.hasGroup() && !this.hasPivot() && !this.hasRowLimit() && !this.hasRowOffset() && !this.hasUserFormatOptions() && !this.hasLabels() && !this.hasOptions();
    }

    public void copyFrom(Query query) {
        this.setSort(query.getSort());
        this.setSelection(query.getSelection());
        this.setFilter(query.getFilter());
        this.setGroup(query.getGroup());
        this.setPivot(query.getPivot());
        this.copyRowLimit(query);
        this.copyRowOffset(query);
        this.setUserFormatOptions(query.getUserFormatOptions());
        this.setLabels(query.getLabels());
        this.setOptions(query.getOptions());
    }

    public void validate() throws InvalidQueryException {
        HashSet formatColumns;
        String messageToLogAndUser;
        String messageToLogAndUser2;
        String messageToLogAndUser3;
        String id;
        String messageToLogAndUser4;
        List<AggregationColumn> filterAggregations;
        ArrayList groupColumnIds = this.hasGroup() ? this.group.getColumnIds() : Lists.newArrayList();
        ArrayList groupColumns = this.hasGroup() ? this.group.getColumns() : Lists.newArrayList();
        ArrayList pivotColumnIds = this.hasPivot() ? this.pivot.getColumnIds() : Lists.newArrayList();
        ArrayList selectionColumns = this.hasSelection() ? this.selection.getColumns() : Lists.newArrayList();
        ArrayList selectionAggregated = this.hasSelection() ? this.selection.getAggregationColumns() : Lists.newArrayList();
        ArrayList selectionSimple = this.hasSelection() ? this.selection.getSimpleColumns() : Lists.newArrayList();
        ArrayList selectedScalarFunctionColumns = this.hasSelection() ? this.selection.getScalarFunctionColumns() : Lists.newArrayList();
        selectedScalarFunctionColumns.addAll(selectedScalarFunctionColumns);
        ArrayList sortColumns = this.hasSort() ? this.sort.getColumns() : Lists.newArrayList();
        ArrayList sortAggregated = this.hasSort() ? this.sort.getAggregationColumns() : Lists.newArrayList();
        Query.checkForDuplicates(selectionColumns, "SELECT");
        Query.checkForDuplicates(sortColumns, "ORDER BY");
        Query.checkForDuplicates(groupColumnIds, "GROUP BY");
        Query.checkForDuplicates(pivotColumnIds, "PIVOT");
        if (this.hasGroup()) {
            for (AbstractColumn column : this.group.getColumns()) {
                if (column.getAllAggregationColumns().isEmpty()) continue;
                String messageToLogAndUser5 = "Column [" + column.toQueryString() + "] connot be in" + " GROUP BY because it has an aggregation.";
                log.error((Object)messageToLogAndUser5);
                throw new InvalidQueryException(messageToLogAndUser5);
            }
        }
        if (this.hasPivot()) {
            for (AbstractColumn column : this.pivot.getColumns()) {
                if (column.getAllAggregationColumns().isEmpty()) continue;
                String messageToLogAndUser6 = "Column [" + column.toQueryString() + "] connot be in" + " PIVOT because it has an aggregation.";
                log.error((Object)messageToLogAndUser6);
                throw new InvalidQueryException(messageToLogAndUser6);
            }
        }
        if (this.hasFilter() && !(filterAggregations = this.filter.getAggregationColumns()).isEmpty()) {
            messageToLogAndUser4 = "Column [" + filterAggregations.get(0).toQueryString() + "] " + " cannot appear in WHERE because it has an aggregation.";
            log.error((Object)messageToLogAndUser4);
            throw new InvalidQueryException(messageToLogAndUser4);
        }
        for (SimpleColumn column1 : selectionSimple) {
            id = column1.getColumnId();
            for (AggregationColumn column2 : selectionAggregated) {
                if (!id.equals(column2.getAggregatedColumn().getId())) continue;
                String messageToLogAndUser7 = "Column [" + id + "] cannot be " + "selected both with and without aggregation in SELECT.";
                log.error((Object)messageToLogAndUser7);
                throw new InvalidQueryException(messageToLogAndUser7);
            }
        }
        if (!selectionAggregated.isEmpty()) {
            for (AbstractColumn col : selectionColumns) {
                this.checkSelectedColumnWithGrouping(groupColumns, col);
            }
        }
        if (this.hasSelection() && this.hasGroup()) {
            for (AbstractColumn column : selectionAggregated) {
                id = ((AggregationColumn)column).getAggregatedColumn().getId();
                if (!groupColumnIds.contains(id)) continue;
                messageToLogAndUser3 = "Column [" + id + "] which is " + "aggregated in SELECT, cannot appear in GROUP BY.";
                log.error((Object)messageToLogAndUser3);
                throw new InvalidQueryException(messageToLogAndUser3);
            }
        }
        if (this.hasGroup() && selectionAggregated.isEmpty()) {
            messageToLogAndUser2 = "Cannot use GROUP BY when no aggregations are defined in SELECT.";
            log.error((Object)messageToLogAndUser2);
            throw new InvalidQueryException(messageToLogAndUser2);
        }
        if (this.hasPivot() && selectionAggregated.isEmpty()) {
            messageToLogAndUser2 = "Cannot use PIVOT when no aggregations are defined in SELECT.";
            log.error((Object)messageToLogAndUser2);
            throw new InvalidQueryException(messageToLogAndUser2);
        }
        if (this.hasSort() && !selectionAggregated.isEmpty()) {
            for (AbstractColumn column : this.sort.getColumns()) {
                messageToLogAndUser = "Column [" + column.toQueryString() + "] which " + "appears in ORDER BY, must be in SELECT as well, because SELECT" + " contains aggregated columns.";
                this.checkColumnInList(this.selection.getColumns(), column, messageToLogAndUser);
            }
        }
        if (this.hasPivot()) {
            for (AbstractColumn column : selectionAggregated) {
                id = ((AggregationColumn)column).getAggregatedColumn().getId();
                if (!pivotColumnIds.contains(id)) continue;
                messageToLogAndUser3 = "Column [" + id + "] which is " + "aggregated in SELECT, cannot appear in PIVOT.";
                log.error((Object)messageToLogAndUser3);
                throw new InvalidQueryException(messageToLogAndUser3);
            }
        }
        if (this.hasGroup() && this.hasPivot()) {
            for (String id2 : groupColumnIds) {
                if (!pivotColumnIds.contains(id2)) continue;
                messageToLogAndUser = "Column [" + id2 + "] cannot appear" + " both in GROUP BY and in PIVOT.";
                log.error((Object)messageToLogAndUser);
                throw new InvalidQueryException(messageToLogAndUser);
            }
        }
        if (this.hasPivot() && !sortAggregated.isEmpty()) {
            AggregationColumn column = (AggregationColumn)sortAggregated.get(0);
            messageToLogAndUser4 = "Column [" + column.getAggregatedColumn().getId() + "] " + "cannot be aggregated " + "in ORDER BY when PIVOT is used.";
            log.error((Object)messageToLogAndUser4);
            throw new InvalidQueryException(messageToLogAndUser4);
        }
        for (AbstractColumn column : sortAggregated) {
            messageToLogAndUser = "Aggregation [" + ((AggregationColumn)column).toQueryString() + "] " + "found in ORDER BY but was not found in SELECT";
            this.checkColumnInList(selectionAggregated, column, messageToLogAndUser);
        }
        HashSet labelColumns = this.hasLabels() ? this.labels.getColumns() : Sets.newHashSet();
        Set<Object> set = formatColumns = this.hasUserFormatOptions() ? this.userFormatOptions.getColumns() : Sets.newHashSet();
        if (this.hasSelection()) {
            String messageToLogAndUser8;
            for (AbstractColumn col : labelColumns) {
                if (selectionColumns.contains(col)) continue;
                messageToLogAndUser8 = "Column [" + col.toQueryString() + "] which" + " is referenced in LABEL, is not part of SELECT clause.";
                log.error((Object)messageToLogAndUser8);
                throw new InvalidQueryException(messageToLogAndUser8);
            }
            for (AbstractColumn col : formatColumns) {
                if (selectionColumns.contains(col)) continue;
                messageToLogAndUser8 = "Column [" + col.toQueryString() + "] which" + " is referenced in FORMAT, is not part of SELECT clause.";
                log.error((Object)messageToLogAndUser8);
                throw new InvalidQueryException(messageToLogAndUser8);
            }
        }
    }

    public Set<String> getAllColumnIds() {
        HashSet result = Sets.newHashSet();
        if (this.hasSelection()) {
            for (AbstractColumn col : this.selection.getColumns()) {
                result.addAll(col.getAllSimpleColumnIds());
            }
        }
        if (this.hasSort()) {
            for (AbstractColumn col : this.sort.getColumns()) {
                result.addAll(col.getAllSimpleColumnIds());
            }
        }
        if (this.hasGroup()) {
            result.addAll(this.getGroup().getSimpleColumnIds());
        }
        if (this.hasPivot()) {
            result.addAll(this.getPivot().getSimpleColumnIds());
        }
        if (this.hasFilter()) {
            result.addAll(this.getFilter().getAllColumnIds());
        }
        if (this.hasLabels()) {
            for (AbstractColumn col : this.labels.getColumns()) {
                result.addAll(col.getAllSimpleColumnIds());
            }
        }
        if (this.hasUserFormatOptions()) {
            for (AbstractColumn col : this.userFormatOptions.getColumns()) {
                result.addAll(col.getAllSimpleColumnIds());
            }
        }
        return result;
    }

    public Set<AggregationColumn> getAllAggregations() {
        HashSet result = Sets.newHashSet();
        if (this.hasSelection()) {
            result.addAll(this.selection.getAggregationColumns());
        }
        if (this.hasSort()) {
            for (AbstractColumn col : this.sort.getColumns()) {
                if (!(col instanceof AggregationColumn)) continue;
                result.add((AggregationColumn)col);
            }
        }
        if (this.hasLabels()) {
            for (AbstractColumn col : this.labels.getColumns()) {
                if (!(col instanceof AggregationColumn)) continue;
                result.add((AggregationColumn)col);
            }
        }
        if (this.hasUserFormatOptions()) {
            for (AbstractColumn col : this.userFormatOptions.getColumns()) {
                if (!(col instanceof AggregationColumn)) continue;
                result.add((AggregationColumn)col);
            }
        }
        return result;
    }

    public Set<ScalarFunctionColumn> getAllScalarFunctionsColumns() {
        HashSet mentionedScalarFunctionColumns = Sets.newHashSet();
        if (this.hasSelection()) {
            mentionedScalarFunctionColumns.addAll(this.selection.getScalarFunctionColumns());
        }
        if (this.hasFilter()) {
            mentionedScalarFunctionColumns.addAll(this.filter.getScalarFunctionColumns());
        }
        if (this.hasGroup()) {
            mentionedScalarFunctionColumns.addAll(this.group.getScalarFunctionColumns());
        }
        if (this.hasPivot()) {
            mentionedScalarFunctionColumns.addAll(this.pivot.getScalarFunctionColumns());
        }
        if (this.hasSort()) {
            mentionedScalarFunctionColumns.addAll(this.sort.getScalarFunctionColumns());
        }
        if (this.hasLabels()) {
            mentionedScalarFunctionColumns.addAll(this.labels.getScalarFunctionColumns());
        }
        if (this.hasUserFormatOptions()) {
            mentionedScalarFunctionColumns.addAll(this.userFormatOptions.getScalarFunctionColumns());
        }
        return mentionedScalarFunctionColumns;
    }

    private void checkColumnInList(List<? extends AbstractColumn> columns, AbstractColumn column, String messageToLogAndUser) throws InvalidQueryException {
        if (columns.contains(column)) {
            return;
        }
        if (column instanceof ScalarFunctionColumn) {
            List<AbstractColumn> innerColumns = ((ScalarFunctionColumn)column).getColumns();
            for (AbstractColumn innerColumn : innerColumns) {
                this.checkColumnInList(columns, innerColumn, messageToLogAndUser);
            }
        } else {
            log.error((Object)messageToLogAndUser);
            throw new InvalidQueryException(messageToLogAndUser);
        }
    }

    private void checkSelectedColumnWithGrouping(List<AbstractColumn> groupColumns, AbstractColumn col) throws InvalidQueryException {
        if (col instanceof SimpleColumn) {
            if (!groupColumns.contains(col)) {
                String messageToLogAndUser = "Column [" + col.getId() + "] should be added to GROUP BY, removed from SELECT, or " + "aggregated in SELECT.";
                log.error((Object)messageToLogAndUser);
                throw new InvalidQueryException(messageToLogAndUser);
            }
        } else if (col instanceof ScalarFunctionColumn && !groupColumns.contains(col)) {
            List<AbstractColumn> innerColumns = ((ScalarFunctionColumn)col).getColumns();
            for (AbstractColumn innerColumn : innerColumns) {
                this.checkSelectedColumnWithGrouping(groupColumns, innerColumn);
            }
        }
    }

    public int hashCode() {
        int prime = 37;
        int result = 1;
        result = 37 * result + (this.filter == null ? 0 : this.filter.hashCode());
        result = 37 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 37 * result + (this.labels == null ? 0 : this.labels.hashCode());
        result = 37 * result + (this.options == null ? 0 : this.options.hashCode());
        result = 37 * result + (this.pivot == null ? 0 : this.pivot.hashCode());
        result = 37 * result + this.rowLimit;
        result = 37 * result + this.rowOffset;
        result = 37 * result + (this.selection == null ? 0 : this.selection.hashCode());
        result = 37 * result + (this.sort == null ? 0 : this.sort.hashCode());
        result = 37 * result + (this.userFormatOptions == null ? 0 : this.userFormatOptions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Query other = (Query)obj;
        if (this.filter == null ? other.filter != null : !this.filter.equals(other.filter)) {
            return false;
        }
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        if (this.labels == null ? other.labels != null : !this.labels.equals(other.labels)) {
            return false;
        }
        if (this.options == null ? other.options != null : !this.options.equals(other.options)) {
            return false;
        }
        if (this.pivot == null ? other.pivot != null : !this.pivot.equals(other.pivot)) {
            return false;
        }
        if (this.rowLimit != other.rowLimit) {
            return false;
        }
        if (this.rowOffset != other.rowOffset) {
            return false;
        }
        if (this.selection == null ? other.selection != null : !this.selection.equals(other.selection)) {
            return false;
        }
        if (this.sort == null ? other.sort != null : !this.sort.equals(other.sort)) {
            return false;
        }
        return !(this.userFormatOptions == null ? other.userFormatOptions != null : !this.userFormatOptions.equals(other.userFormatOptions));
    }

    static String columnListToQueryString(List<AbstractColumn> l) {
        StrBuilder builder = new StrBuilder();
        ArrayList stringList = Lists.newArrayList();
        for (AbstractColumn col : l) {
            stringList.add(col.toQueryString());
        }
        builder.appendWithSeparators((Collection)stringList, ", ");
        return builder.toString();
    }

    static String stringToQueryStringLiteral(String s) {
        if (s.contains("\"")) {
            if (s.contains("'")) {
                throw new RuntimeException("Cannot represent string that contains both double-quotes (\")  and single quotes (').");
            }
            return "'" + s + "'";
        }
        return "\"" + s + "\"";
    }

    public String toQueryString() {
        ArrayList clauses = Lists.newArrayList();
        if (this.hasSelection()) {
            clauses.add("SELECT " + this.selection.toQueryString());
        }
        if (this.hasFilter()) {
            clauses.add("WHERE " + this.filter.toQueryString());
        }
        if (this.hasGroup()) {
            clauses.add("GROUP BY " + this.group.toQueryString());
        }
        if (this.hasPivot()) {
            clauses.add("PIVOT " + this.pivot.toQueryString());
        }
        if (this.hasSort()) {
            clauses.add("ORDER BY " + this.sort.toQueryString());
        }
        if (this.hasRowLimit()) {
            clauses.add("LIMIT " + this.rowLimit);
        }
        if (this.hasRowOffset()) {
            clauses.add("OFFSET " + this.rowOffset);
        }
        if (this.hasLabels()) {
            clauses.add("LABEL " + this.labels.toQueryString());
        }
        if (this.hasUserFormatOptions()) {
            clauses.add("FORMAT " + this.userFormatOptions.toQueryString());
        }
        if (this.hasOptions()) {
            clauses.add("OPTIONS " + this.options.toQueryString());
        }
        StrBuilder result = new StrBuilder();
        result.appendWithSeparators((Collection)clauses, " ");
        return result.toString();
    }
}

