/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.query.QueryFilter;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class ComparisonFilter
extends QueryFilter {
    protected Operator operator;

    protected ComparisonFilter(Operator operator) {
        this.operator = operator;
    }

    private boolean isLike(String s1, String s2) {
        StringTokenizer tokenizer = new StringTokenizer(s2, "%_", true);
        StringBuilder regexp = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            if (s.equals("%")) {
                regexp.append(".*");
                continue;
            }
            if (s.equals("_")) {
                regexp.append(".");
                continue;
            }
            regexp.append(Pattern.quote(s));
        }
        return s1.matches(regexp.toString());
    }

    protected boolean isOperatorMatch(Value v1, Value v2) {
        if (this.operator.areEqualTypesRequired() && !v1.getType().equals((Object)v2.getType())) {
            return false;
        }
        switch (this.operator) {
            case EQ: {
                return v1.compareTo(v2) == 0;
            }
            case NE: {
                return v1.compareTo(v2) != 0;
            }
            case LT: {
                return v1.compareTo(v2) < 0;
            }
            case GT: {
                return v1.compareTo(v2) > 0;
            }
            case LE: {
                return v1.compareTo(v2) <= 0;
            }
            case GE: {
                return v1.compareTo(v2) >= 0;
            }
            case CONTAINS: {
                return v1.toString().contains(v2.toString());
            }
            case STARTS_WITH: {
                return v1.toString().startsWith(v2.toString());
            }
            case ENDS_WITH: {
                return v1.toString().endsWith(v2.toString());
            }
            case MATCHES: {
                try {
                    return v1.toString().matches(v2.toString());
                }
                catch (PatternSyntaxException ex) {
                    return false;
                }
            }
            case LIKE: {
                return this.isLike(v1.toString(), v2.toString());
            }
        }
        return false;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public static enum Operator {
        EQ("=", true),
        NE("!=", true),
        LT("<", true),
        GT(">", true),
        LE("<=", true),
        GE(">=", true),
        CONTAINS("CONTAINS", false),
        STARTS_WITH("STARTS WITH", false),
        ENDS_WITH("ENDS WITH", false),
        MATCHES("MATCHES", false),
        LIKE("LIKE", false);

        private boolean requiresEqualTypes;
        private String queryStringForm;

        private Operator(String queryStringForm, boolean requiresEqualTypes) {
            this.queryStringForm = queryStringForm;
            this.requiresEqualTypes = requiresEqualTypes;
        }

        public boolean areEqualTypesRequired() {
            return this.requiresEqualTypes;
        }

        public String toQueryString() {
            return this.queryStringForm;
        }
    }
}

