/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.ComparisonFilter;
import com.google.visualization.datasource.query.DataTableColumnLookup;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ColumnColumnFilter
extends ComparisonFilter {
    private AbstractColumn firstColumn;
    private AbstractColumn secondColumn;

    public ColumnColumnFilter(AbstractColumn firstColumn, AbstractColumn secondColumn, ComparisonFilter.Operator operator) {
        super(operator);
        this.firstColumn = firstColumn;
        this.secondColumn = secondColumn;
    }

    @Override
    public boolean isMatch(DataTable table, TableRow row) {
        DataTableColumnLookup lookup = new DataTableColumnLookup(table);
        Value firstValue = this.firstColumn.getValue(lookup, row);
        Value secondValue = this.secondColumn.getValue(lookup, row);
        return this.isOperatorMatch(firstValue, secondValue);
    }

    @Override
    public Set<String> getAllColumnIds() {
        HashSet columnIds = Sets.newHashSet(this.firstColumn.getAllSimpleColumnIds());
        columnIds.addAll(this.secondColumn.getAllSimpleColumnIds());
        return columnIds;
    }

    @Override
    public List<ScalarFunctionColumn> getScalarFunctionColumns() {
        ArrayList scalarFunctionColumns = Lists.newArrayList();
        scalarFunctionColumns.addAll(this.firstColumn.getAllScalarFunctionColumns());
        scalarFunctionColumns.addAll(this.secondColumn.getAllScalarFunctionColumns());
        return scalarFunctionColumns;
    }

    @Override
    protected List<AggregationColumn> getAggregationColumns() {
        ArrayList aggregationColumns = Lists.newArrayList();
        aggregationColumns.addAll(this.firstColumn.getAllAggregationColumns());
        aggregationColumns.addAll(this.secondColumn.getAllAggregationColumns());
        return aggregationColumns;
    }

    public AbstractColumn getFirstColumn() {
        return this.firstColumn;
    }

    public AbstractColumn getSecondColumn() {
        return this.secondColumn;
    }

    @Override
    public String toQueryString() {
        return this.firstColumn.toQueryString() + " " + this.operator.toQueryString() + " " + this.secondColumn.toQueryString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.firstColumn == null ? 0 : this.firstColumn.hashCode());
        result = 31 * result + (this.secondColumn == null ? 0 : this.secondColumn.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnColumnFilter other = (ColumnColumnFilter)obj;
        if (this.firstColumn == null ? other.firstColumn != null : !this.firstColumn.equals(other.firstColumn)) {
            return false;
        }
        return !(this.secondColumn == null ? other.secondColumn != null : !this.secondColumn.equals(other.secondColumn));
    }
}

