/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.Lists;
import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationType;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import com.google.visualization.datasource.query.SimpleColumn;
import java.util.List;

public class AggregationColumn
extends AbstractColumn {
    public static final String COLUMN_AGGRGATION_TYPE_SEPARATOR = "-";
    private SimpleColumn aggregatedColumn;
    private AggregationType aggregationType;

    public AggregationColumn(SimpleColumn aggregatedColumn, AggregationType aggregationType) {
        this.aggregatedColumn = aggregatedColumn;
        this.aggregationType = aggregationType;
    }

    @Override
    public String getId() {
        return this.aggregationType.getCode() + COLUMN_AGGRGATION_TYPE_SEPARATOR + this.aggregatedColumn.getId();
    }

    public SimpleColumn getAggregatedColumn() {
        return this.aggregatedColumn;
    }

    @Override
    public List<String> getAllSimpleColumnIds() {
        return Lists.newArrayList((Object[])new String[]{this.aggregatedColumn.getId()});
    }

    @Override
    public List<SimpleColumn> getAllSimpleColumns() {
        return Lists.newArrayList();
    }

    @Override
    public List<AggregationColumn> getAllAggregationColumns() {
        return Lists.newArrayList((Object[])new AggregationColumn[]{this});
    }

    @Override
    public List<ScalarFunctionColumn> getAllScalarFunctionColumns() {
        return Lists.newArrayList();
    }

    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    @Override
    public void validateColumn(DataTable dataTable) throws InvalidQueryException {
        ValueType valueType = dataTable.getColumnDescription(this.aggregatedColumn.getId()).getType();
        switch (this.aggregationType) {
            case COUNT: 
            case MAX: 
            case MIN: {
                break;
            }
            case AVG: 
            case SUM: {
                if (valueType == ValueType.NUMBER) break;
                throw new InvalidQueryException("'Average' and 'sum' aggreagation functions can be applied only on numeric values.");
            }
            default: {
                throw new RuntimeException("Invalid aggregation type: " + (Object)((Object)this.aggregationType));
            }
        }
    }

    @Override
    public ValueType getValueType(DataTable dataTable) {
        ValueType valueType;
        ValueType originalValueType = dataTable.getColumnDescription(this.aggregatedColumn.getId()).getType();
        switch (this.aggregationType) {
            case COUNT: {
                valueType = ValueType.NUMBER;
                break;
            }
            case MAX: 
            case MIN: 
            case AVG: 
            case SUM: {
                valueType = originalValueType;
                break;
            }
            default: {
                throw new RuntimeException("Invalid aggregation type: " + (Object)((Object)this.aggregationType));
            }
        }
        return valueType;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof AggregationColumn) {
            AggregationColumn other = (AggregationColumn)o;
            return this.aggregatedColumn.equals(other.aggregatedColumn) && this.aggregationType.equals((Object)other.aggregationType);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 1279;
        hash = hash * 17 + this.aggregatedColumn.hashCode();
        hash = hash * 17 + this.aggregationType.hashCode();
        return hash;
    }

    public String toString() {
        return this.aggregationType.getCode() + "(" + this.aggregatedColumn.getId() + ")";
    }

    @Override
    public String toQueryString() {
        return this.aggregationType.getCode().toUpperCase() + "(" + this.aggregatedColumn.toQueryString() + ")";
    }
}

