/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable.value;

import com.google.visualization.datasource.datatable.value.NullValueException;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;

public class DateTimeValue
extends Value {
    private static final DateTimeValue NULL_VALUE = new DateTimeValue();
    private GregorianCalendar calendar;
    private Integer hashCode = null;

    public static DateTimeValue getNullValue() {
        return NULL_VALUE;
    }

    private DateTimeValue() {
        this.hashCode = 0;
    }

    public DateTimeValue(int year, int month, int dayOfMonth, int hours, int minutes, int seconds, int milliseconds) {
        this.calendar = new GregorianCalendar(year, month, dayOfMonth, hours, minutes, seconds);
        this.calendar.set(14, milliseconds);
        this.calendar.setTimeZone(TimeZone.getTimeZone((String)"GMT"));
        if (this.getYear() != year || this.getMonth() != month || this.getDayOfMonth() != dayOfMonth || this.getHourOfDay() != hours || this.getMinute() != minutes || this.getSecond() != seconds || this.getMillisecond() != milliseconds) {
            throw new IllegalArgumentException("Invalid java date (yyyy-MM-dd hh:mm:ss.S): " + year + '-' + month + '-' + dayOfMonth + ' ' + hours + ':' + minutes + ':' + seconds + '.' + milliseconds);
        }
    }

    public DateTimeValue(GregorianCalendar calendar) {
        if (!calendar.getTimeZone().equals((Object)TimeZone.getTimeZone((String)"GMT"))) {
            throw new IllegalArgumentException();
        }
        this.calendar = (GregorianCalendar)calendar.clone();
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public int getMonth() {
        return this.calendar.get(2);
    }

    public int getDayOfMonth() {
        return this.calendar.get(5);
    }

    public int getHourOfDay() {
        return this.calendar.get(11);
    }

    public int getMinute() {
        return this.calendar.get(12);
    }

    public int getSecond() {
        return this.calendar.get(13);
    }

    public int getMillisecond() {
        return this.calendar.get(14);
    }

    @Override
    public ValueType getType() {
        return ValueType.DATETIME;
    }

    public String toString() {
        if (this == NULL_VALUE) {
            return "null";
        }
        String result = String.format("%1$d-%2$02d-%3$02d %4$02d:%5$02d:%6$02d", this.getYear(), this.getMonth() + 1, this.getDayOfMonth(), this.getHourOfDay(), this.getMinute(), this.getSecond());
        if (this.getMillisecond() > 0) {
            result = result + "." + String.format("%1$03d", this.getMillisecond());
        }
        return result;
    }

    @Override
    public boolean isNull() {
        return this == NULL_VALUE;
    }

    @Override
    public int compareTo(Value other) {
        if (this == other) {
            return 0;
        }
        DateTimeValue otherDateTime = (DateTimeValue)other;
        if (this.isNull()) {
            return -1;
        }
        if (otherDateTime.isNull()) {
            return 1;
        }
        return this.calendar.compareTo((Calendar)otherDateTime.getCalendar());
    }

    @Override
    public int hashCode() {
        if (null != this.hashCode) {
            return this.hashCode;
        }
        int hash = 1579;
        hash = hash * 11 + this.getYear();
        hash = hash * 11 + this.getMonth();
        hash = hash * 11 + this.getDayOfMonth();
        hash = hash * 11 + this.getHourOfDay();
        hash = hash * 11 + this.getMinute();
        hash = hash * 11 + this.getSecond();
        hash = hash * 11 + this.getMillisecond();
        this.hashCode = hash;
        return this.hashCode;
    }

    public Calendar getObjectToFormat() {
        if (this.isNull()) {
            return null;
        }
        return this.calendar;
    }

    public GregorianCalendar getCalendar() {
        if (this.isNull()) {
            throw new NullValueException("This object is null");
        }
        return this.calendar;
    }

    @Override
    protected String innerToQueryString() {
        String s = "DATETIME '" + this.getYear() + "-" + (this.getMonth() + 1) + "-" + this.getDayOfMonth() + " " + this.getHourOfDay() + ":" + this.getMinute() + ":" + this.getSecond();
        int milli = this.getMillisecond();
        if (milli != 0) {
            s = s + "." + milli;
        }
        s = s + "'";
        return s;
    }
}

