/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable;

import com.google.common.collect.Maps;
import com.google.visualization.datasource.datatable.value.BooleanValue;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.TextValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.ibm.icu.util.ULocale;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public class TableCell {
    private Value value;
    private String formattedValue = null;
    private Map<String, String> customProperties = null;

    public static Comparator<TableCell> getLocalizedComparator(final ULocale ulocale) {
        return new Comparator<TableCell>(){
            private Comparator<TextValue> textValueComparator;
            {
                this.textValueComparator = TextValue.getTextLocalizedComparator(ulocale);
            }

            @Override
            public int compare(TableCell cell1, TableCell cell2) {
                if (cell1 == cell2) {
                    return 0;
                }
                if (cell1.getType() == ValueType.TEXT) {
                    return this.textValueComparator.compare((TextValue)cell1.value, (TextValue)cell2.value);
                }
                return cell1.getValue().compareTo(cell2.getValue());
            }
        };
    }

    public String getFormattedValue() {
        return this.formattedValue;
    }

    public void setFormattedValue(String formattedValue) {
        this.formattedValue = formattedValue;
    }

    public TableCell(Value value) {
        this.value = value;
    }

    public TableCell(Value value, String formattedValue) {
        this.value = value;
        this.formattedValue = formattedValue;
    }

    public TableCell(TableCell other) {
        this(other.value, other.formattedValue);
    }

    public TableCell(String value) {
        this.value = new TextValue(value);
    }

    public TableCell(boolean value) {
        this.value = BooleanValue.getInstance(value);
    }

    public TableCell(double value) {
        this.value = new NumberValue(value);
    }

    public Value getValue() {
        return this.value;
    }

    public ValueType getType() {
        return this.value.getType();
    }

    public boolean isNull() {
        return this.value.isNull();
    }

    public String toString() {
        return this.value.toString();
    }

    public String getCustomProperty(String key) {
        if (this.customProperties == null) {
            return null;
        }
        if (key == null) {
            throw new RuntimeException("Null keys are not allowed.");
        }
        return this.customProperties.get(key);
    }

    public void setCustomProperty(String propertyKey, String propertyValue) {
        if (this.customProperties == null) {
            this.customProperties = Maps.newHashMap();
        }
        if (propertyKey == null || propertyValue == null) {
            throw new RuntimeException("Null keys/values are not allowed.");
        }
        this.customProperties.put(propertyKey, propertyValue);
    }

    public Map<String, String> getCustomProperties() {
        if (this.customProperties == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.customProperties);
    }

    public TableCell clone() {
        TableCell result = new TableCell(this.value, this.formattedValue);
        if (this.customProperties != null) {
            result.customProperties = Maps.newHashMap();
            for (Map.Entry<String, String> entry : this.customProperties.entrySet()) {
                result.customProperties.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }
}

