/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable;

import com.google.common.collect.Maps;
import com.google.visualization.datasource.datatable.value.ValueType;
import java.util.Collections;
import java.util.Map;

public class ColumnDescription {
    private String id;
    private ValueType type;
    private String label;
    private String pattern;
    private Map<String, String> customProperties = null;

    public ColumnDescription(String id, ValueType type, String label) {
        this.id = id;
        this.type = type;
        this.label = label;
        this.pattern = "";
    }

    public String getId() {
        return this.id;
    }

    public ValueType getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getCustomProperty(String key) {
        if (this.customProperties == null) {
            return null;
        }
        if (key == null) {
            throw new RuntimeException("Null keys are not allowed.");
        }
        return this.customProperties.get(key);
    }

    public void setCustomProperty(String propertyKey, String propertyValue) {
        if (this.customProperties == null) {
            this.customProperties = Maps.newHashMap();
        }
        if (propertyKey == null || propertyValue == null) {
            throw new RuntimeException("Null keys/values are not allowed.");
        }
        this.customProperties.put(propertyKey, propertyValue);
    }

    public Map<String, String> getCustomProperties() {
        if (this.customProperties == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.customProperties);
    }

    public ColumnDescription clone() {
        ColumnDescription result = new ColumnDescription(this.id, this.type, this.label);
        result.setPattern(this.pattern);
        if (this.customProperties != null) {
            result.customProperties = Maps.newHashMap();
            for (Map.Entry<String, String> entry : this.customProperties.entrySet()) {
                result.customProperties.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }
}

