/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.base;

import com.google.common.collect.Maps;
import com.google.visualization.datasource.base.LocaleUtil;
import java.util.Locale;
import java.util.Map;

public enum ReasonType {
    ACCESS_DENIED,
    USER_NOT_AUTHENTICATED,
    UNSUPPORTED_QUERY_OPERATION,
    INVALID_QUERY,
    INVALID_REQUEST,
    INTERNAL_ERROR,
    NOT_SUPPORTED,
    DATA_TRUNCATED,
    NOT_MODIFIED,
    TIMEOUT,
    ILLEGAL_FORMATTING_PATTERNS,
    OTHER;

    private static final Map<ReasonType, String> REASON_TYPE_TO_MESSAGE;

    public String getMessageForReasonType(Locale locale) {
        return LocaleUtil.getLocalizedMessageFromBundle("com.google.visualization.datasource.base.ErrorMessages", REASON_TYPE_TO_MESSAGE.get((Object)this), locale);
    }

    public String getMessageForReasonType() {
        return this.getMessageForReasonType(null);
    }

    public String lowerCaseString() {
        return this.toString().toLowerCase();
    }

    static {
        REASON_TYPE_TO_MESSAGE = Maps.newEnumMap(ReasonType.class);
        REASON_TYPE_TO_MESSAGE.put(ACCESS_DENIED, "ACCESS_DENIED");
        REASON_TYPE_TO_MESSAGE.put(USER_NOT_AUTHENTICATED, "USER_NOT_AUTHENTICATED");
        REASON_TYPE_TO_MESSAGE.put(UNSUPPORTED_QUERY_OPERATION, "UNSUPPORTED_QUERY_OPERATION");
        REASON_TYPE_TO_MESSAGE.put(INVALID_QUERY, "INVALID_QUERY");
        REASON_TYPE_TO_MESSAGE.put(INVALID_REQUEST, "INVALID_REQUEST");
        REASON_TYPE_TO_MESSAGE.put(INTERNAL_ERROR, "INTERNAL_ERROR");
        REASON_TYPE_TO_MESSAGE.put(NOT_SUPPORTED, "NOT_SUPPORTED");
        REASON_TYPE_TO_MESSAGE.put(DATA_TRUNCATED, "DATA_TRUNCATED");
        REASON_TYPE_TO_MESSAGE.put(NOT_MODIFIED, "NOT_MODIFIED");
        REASON_TYPE_TO_MESSAGE.put(TIMEOUT, "TIMEOUT");
        REASON_TYPE_TO_MESSAGE.put(ILLEGAL_FORMATTING_PATTERNS, "ILLEGAL_FORMATTING_PATTERNS");
        REASON_TYPE_TO_MESSAGE.put(OTHER, "OTHER");
    }
}

