/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.base;

import com.google.visualization.datasource.base.DataSourceException;
import com.google.visualization.datasource.base.OutputType;
import com.google.visualization.datasource.base.ReasonType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSourceParameters {
    private static final Log log = LogFactory.getLog((String)DataSourceParameters.class.getName());
    private static final String REQUEST_ID_PARAM_NAME = "reqId";
    private static final String SIGNATURE_PARAM_NAME = "sig";
    private static final String OUTPUT_TYPE_PARAM_NAME = "out";
    private static final String RESPONSE_HANDLER_PARAM_NAME = "responseHandler";
    private static final String REQUEST_OUTFILENAME_PARAM_NAME = "outFileName";
    private static final String DEFAULT_ERROR_MSG = "Internal error";
    private String tqxValue = null;
    private String requestId = null;
    private String signature = null;
    private OutputType outputType = OutputType.defaultValue();
    private String responseHandler = "google.visualization.Query.setResponse";
    private String outFileName = "data.csv";

    public static DataSourceParameters getDefaultDataSourceParameters() {
        DataSourceParameters dsParams = null;
        try {
            dsParams = new DataSourceParameters(null);
        }
        catch (DataSourceException dataSourceException) {
            // empty catch block
        }
        return dsParams;
    }

    public DataSourceParameters(String tqxValue) throws DataSourceException {
        String[] parts;
        if (StringUtils.isEmpty((String)tqxValue)) {
            return;
        }
        this.tqxValue = tqxValue;
        for (String part : parts = tqxValue.split(";")) {
            String[] nameValuePair = part.split(":");
            if (nameValuePair.length != 2) {
                log.error((Object)("Invalid name-value pair: " + part));
                throw new DataSourceException(ReasonType.INVALID_REQUEST, "Internal error(malformed)");
            }
            String name = nameValuePair[0];
            String value = nameValuePair[1];
            if (name.equals(REQUEST_ID_PARAM_NAME)) {
                this.requestId = value;
                continue;
            }
            if (name.equals(SIGNATURE_PARAM_NAME)) {
                this.signature = value;
                continue;
            }
            if (name.equals(OUTPUT_TYPE_PARAM_NAME)) {
                this.outputType = OutputType.findByCode(value);
                if (this.outputType != null) continue;
                this.outputType = OutputType.defaultValue();
                continue;
            }
            if (name.equals(RESPONSE_HANDLER_PARAM_NAME)) {
                this.responseHandler = value;
                continue;
            }
            if (!name.equals(REQUEST_OUTFILENAME_PARAM_NAME)) continue;
            this.outFileName = value;
            if (this.outFileName.contains(".")) continue;
            this.outFileName = this.outFileName + ".csv";
        }
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public OutputType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(OutputType outputType) {
        this.outputType = outputType;
    }

    public String getResponseHandler() {
        return this.responseHandler;
    }

    public String getOutFileName() {
        return this.outFileName;
    }

    public String getTqxValue() {
        return this.tqxValue;
    }
}

