/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.base;

import com.ibm.icu.text.UFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;

public class BooleanFormat
extends UFormat {
    private String trueString;
    private String falseString;

    public BooleanFormat() {
        this("true", "false");
    }

    public BooleanFormat(String trueString, String falseString) {
        if (trueString == null || falseString == null) {
            throw new NullPointerException();
        }
        this.trueString = trueString;
        this.falseString = falseString;
    }

    public BooleanFormat(String pattern) {
        String[] valuePatterns = pattern.split(":");
        if (valuePatterns.length != 2) {
            throw new IllegalArgumentException("Cannot construct a boolean format from " + pattern + ". The pattern must contain a single ':' " + "character");
        }
        this.trueString = valuePatterns[0];
        this.falseString = valuePatterns[1];
    }

    public StringBuffer format(Object obj, StringBuffer appendTo, FieldPosition pos) {
        if (null != obj && !(obj instanceof Boolean)) {
            throw new IllegalArgumentException();
        }
        Boolean val = (Boolean)obj;
        if (val == null) {
            pos.setBeginIndex(0);
            pos.setEndIndex(0);
        } else if (val.booleanValue()) {
            appendTo.append(this.trueString);
            pos.setBeginIndex(0);
            pos.setEndIndex(this.trueString.length() - 1);
        } else {
            appendTo.append(this.falseString);
            pos.setBeginIndex(0);
            pos.setEndIndex(this.falseString.length() - 1);
        }
        return appendTo;
    }

    public Boolean parseObject(String source, ParsePosition pos) {
        if (source == null) {
            throw new NullPointerException();
        }
        Boolean value = null;
        if (this.trueString.equalsIgnoreCase(source.trim())) {
            value = Boolean.TRUE;
            pos.setIndex(this.trueString.length());
        } else if (this.falseString.equalsIgnoreCase(source.trim())) {
            value = Boolean.FALSE;
            pos.setIndex(this.falseString.length());
        }
        if (null == value) {
            pos.setErrorIndex(0);
        }
        return value;
    }

    public Boolean parse(String text) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Boolean result = this.parseObject(text, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new ParseException("Unparseable boolean: \"" + text + '\"', parsePosition.getErrorIndex());
        }
        return result;
    }
}

